\name{PLD_stat_mig}

\alias{PLD_stat_mig}

\title{
Dispersal statistics
}

\description{
Function that lists the dispersal events from the genealogies sampled by the MCMC.
}

\usage{
PLD_stat_mig(x, sub_sample = 0, first = FALSE)
}

\arguments{
  \item{x }{
 an object of class "phyloland" generated by a call to \link{PLD_interface}.
}

  \item{sub_sample }{
 a vector of integers that specifies the indexes of the trees and locations to take into account to list the dispersals events. 
 Default is 0, all trees and locations are considered.
}

  \item{first }{
 a logical value. If TRUE only the oldest dispersal to a location is taken into account. 
 If FALSE all dispersals are taken into account.
}
}

\value{
 \item{migmat }{  a matrix containing the number of occurences of each dispersal event (departures in rows and destinations in columns).}
 \item{timemat }{  a 3-dimensional (a*b*c) array with (a) the departure locations, (b) the destination locations and (c) the time (node height) of the dispersal from (a) to (b).}
}

\examples{
data(Banza)
stat = PLD_stat_mig(x = Banza, sub_sample = 100:200, first = TRUE)
stat$migmat
stat$timemat[,,100]
}

