% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phybreakdata.R
\name{phybreakdata}
\alias{phybreakdata}
\title{Create a phybreakdata-object from raw data.}
\usage{
phybreakdata(sequences, sample.times, sample.names = NULL,
  host.names = sample.names, sim.infection.times = NULL,
  sim.infectors = NULL, sim.tree = NULL)
}
\arguments{
\item{sequences}{Sequence data of class \code{'DNAbin'}, \code{'phyDat'}, or a \code{matrix} with nucleotides, 
each row a host, each column a nucleotide). In a matrix, nucleotides should be lower-case letters. All undefined 
nucleotides or ambiguity codes will be turned into \code{'n'}.}

\item{sample.times}{A vector of sampling times (\code{numerical} or \code{Date}).}

\item{sample.names}{A vector with sample names.}

\item{host.names}{A vector with host names. The vector identifies the host for each sample, so should be of the same
length as \code{sample.times}.}

\item{sim.infection.times}{A vector with infection times (\code{numerical} or \code{Date}).}

\item{sim.infectors}{A vector with infectors, either by name or by position (use 0 for the index case).}

\item{sim.tree}{A tree of class \code{'phylo'}, with tip names identifying the hosts.}
}
\value{
An object of class \code{phybreakdata} with the following elements
  \describe{
    \item{sequences}{a \code{'phyDat'}-object with the sequence data.}
    \item{sample.times}{a named \code{vector} with the sample times.}
    \item{sample.hosts}{a named \code{vector} with the hosts from whom the samples have been taken.}
    \item{sim.infection.times}{a named \code{vector} with the (simulated) infection times (if provided).}
    \item{sim.infectors}{a named \code{vector} with the (simulated) infectors (if provided).}
    \item{sim.tree}{a \code{'phylo'}-object with the (simulated) phylogenetic tree (if provided).}
  }
}
\description{
phybreakdata takes as data sequences and sampling times and makes a \code{phybreakdata} object.
If no host names are provided, each sample is assumed to be associated with a separate host. The number of sequences
should be equal to the length of the sampling time vector, and the position identifies the host (unless named
vectors are provided). Sample names can be provided separately;
otherwise it will be tried to extract them from the sequences or sampling times.
It is also possible to include (otherwise unobserved) simulated data: sim.infection times, sim.infectors, 
and a (phylogenetic) sim.tree. This is done automatically when using \code{\link{sim.phybreak}}.
}
\examples{
sampletimedata <- c(0,2,2,4,4)
sampleSNPdata <- matrix(c("a","a","a","a","a",
                          "a","c","c","c","c",
                          "t","t","t","g","g"), nrow = 5, 
                          dimnames = list(LETTERS[1:5], NULL))
dataset <- phybreakdata(sequences = sampleSNPdata, sample.times = sampletimedata)
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
