% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_simplified_ts.R
\name{gen_simplified_ts}
\alias{gen_simplified_ts}
\title{Generate Simplified TS domain xpt file}
\usage{
gen_simplified_ts(studyid, tsparmcd = "SSTDTC",
  tsval = format(Sys.time(), "\%Y-\%m-\%d"), tsvalnf = " ",
  ofn = "ts.xpt")
}
\arguments{
\item{studyid}{is Study Identifier(STUDYID); required.}

\item{tsparmcd}{is Trial Summary Parameter Short Name(TSPARMCD); defaults
to 'SSTDTC'}

\item{tsval}{is Parameter Value(TSVAL); defaults to current date in format
of "YYYY-MM-DD"}

\item{tsvalnf}{is Parameter Null Flavor(TSVALNF); default to blank}

\item{ofn}{is output file name}
}
\description{
This procedure creates a simplified trial summary SAS xpt file.
}
\examples{
\dontrun{
  library(phuse)
  fn <- gen_simplified_ts();
}
}
\author{
Hanming Tu
}
