% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photobiologySensors.r
\docType{package}
\name{photobiologySensors-package}
\alias{photobiologySensors}
\alias{photobiologySensors-package}
\title{photobiologySensors: Response Data for Light Sensors}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Spectral response data for broadband ultraviolet and visible radiation sensors. Angular response data for broadband ultraviolet and visible radiation sensors and diffusers used as entrance optics. Data obtained from multiple sources were used: author-supplied data from scientific research papers, sensor-manufacturer supplied data, and published sensor specifications. Part of the 'r4photobiology' suite Aphalo P. J. (2015) \doi{10.19232/uv4pb.2015.1.14}.
}
\details{
Data for spectral response for different types of broadband sensors are
stored as objects of class \code{sensor_spct} as collection members in
an object of class \code{sensor_mspct}.
In addition to the spectra the package provides character vectors of names
to be used as indexes to extract spectra from the collection.

Data for angular response for different types of broadband sensors and some
diffusers used as entrance optics for spectrometers are stored as objects
of class \code{data.frame} as members of a \code{list}.
In addition to the list of data frames, the package provides character vectors of names
to be used as indexes to extract the data frames from the named list.

The data in this package are not original. Some have been provided by
authors of scientific publications and manufacturers. However, most of
the spectra have been digitized from manufacturer's brochures and manuals
available on web sites.
}
\section{Warning!}{

The spectral data included in this package are not all based on supplier's
specifications and are only for information. The exact response spectrum
depends to some extent on testing conditions, but more importantly varies among
individual sensor units. Spectral specifications are usually given as typical
values. All the sensors for which data are presented here need periodic
calibration. In other words, the data provided here are not a substitute
for actual calibration under measuring conditions for each individual sensor
unit. For less demanding situations like roughly assessing the suitability
of sensors or the need or not of a transfer calibration, the data are good
enough. They can be especially useful in teaching.
}

\section{Data and their units of expression}{
 Data are normalized to one at
  the wavelength of maximum response to energy. Wavelengths are expressed in
  nanometres as required by the classes from package 'photobiology' used to
  store the data. The User Guide shows how to re-scale and normalize the data
  using other criteria.
}

\examples{
library(photobiology)
library(photobiologyWavebands)
library(ggspectra)

names(sensors.mspct)

licor_sensors
par_sensors
intersect(par_sensors, licor_sensors)

photon_as_default()

response(sensors.mspct$LICOR_LI_190R, w.band = PAR(), quantity = "contribution.pc")

autoplot(sensors.mspct$LICOR_LI_190R, w.band = PAR(), label.qty = "contribution.pc")

names(diffusers.lst)

cosine_diffusers

}
\references{
Aphalo, Pedro J. (2015) The r4photobiology suite. UV4Plants Bulletin, 2015:1,
21-29. \doi{10.19232/uv4pb.2015.1.14}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://www.r4photobiology.info}
  \item \url{https://github.com/aphalo/photobiologysensors}
  \item Report bugs at \url{https://github.com/aphalo/photobiologysensors/issues}
}

}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi} (\href{https://orcid.org/0000-0003-3385-972X}{ORCID})

}
