% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-conversion.r
\name{rspec2mspct}
\alias{rspec2mspct}
\title{Convert "pavo::rspec' objects}
\usage{
rspec2mspct(x, member.class = "reflector_spct", spct.data.var = "Rpc",
  multiplier = 1, ...)
}
\arguments{
\item{x}{rpec object}

\item{member.class}{character One of the spectrum classes defined in package
'photobiology'.}

\item{spct.data.var}{character The name to be used for the 'spc' data when
constructing the spectral objects.}

\item{multiplier}{numeric A multiplier to be applied to the 'rspc' data 
to do unit or scale conversion.}

\item{...}{currently ignored.}
}
\description{
Convert between 'pavo::rspec' objects and collection of spectra
objects (xxxx_mspct) as defined in package 'photobiology' preserving all
information. Collection of spectra objects can be easily converted into
long spectral objects or into tidy data frames.
}
\note{
hyperSpec objects use memory more efficiently than spectral objects
of the classes defined in package 'photobiology' while these are more
flexible as they are derived from 'tbl_df' and in turn from 'data.frame'.

Objects of class "pavo::rspec" do not contain metadata or class data
  from which the quantity measured and the units of expression could be 
  obtained. When using this function the user needs to use parameter 
  \code{multiplier} to convert the data to what is expected by the object
  constructors defined in package 'photobiology' and use parameter
  \code{spct.data.var} to select the quantity.
}
\examples{

library(pavo)
data(sicalis)
sicalis.mspct <- rspec2mspct(sicalis)
class(sicalis.mspct)

}

