% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.reflectance.r
\name{reflectance.reflector_mspct}
\alias{reflectance}
\alias{reflectance.default}
\alias{reflectance.object_mspct}
\alias{reflectance.object_spct}
\alias{reflectance.reflector_mspct}
\alias{reflectance.reflector_spct}
\title{Reflectance}
\usage{
\method{reflectance}{reflector_mspct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ..., idx = !is.null(names(spct)))

\method{reflectance}{object_mspct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ..., idx = !is.null(names(spct)))

reflectance(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{reflectance}{default}(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{reflectance}{reflector_spct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ...)

\method{reflectance}{object_spct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)
}
\arguments{
\item{spct}{an R object}

\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the region(s) of the spectrum that are summarized.}

\item{quantity}{character}

\item{wb.trim}{logical Flag telling if wavebands crossing spectral data boundaries
are trimmed or ignored}

\item{use.hinges}{logical Flag indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
A single numeric value with no change in scale factor
}
\description{
Function to calculate the mean, total, or other summary of reflectance for
spectral data stored in a \code{reflector_spct} or in an \code{object_spct}.
}
\section{Methods (by class)}{
\itemize{
\item \code{reflector_mspct}: Calculates reflectance from a \code{reflector_mspct}

\item \code{object_mspct}: Calculates reflectance from a \code{object_mspct}

\item \code{default}: Default for generic function

\item \code{reflector_spct}: Specialization for reflector_spct

\item \code{object_spct}: Specialization for object_spct
}}
\note{
The \code{use.hinges} parameter controls speed optimization. The
  defaults should be suitable in most cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\examples{
reflectance(black_body.spct, waveband(c(400,700)))
reflectance(white_body.spct, waveband(c(400,700)))

}

