% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.integrate.r
\name{interpolate_spct}
\alias{interpolate_mspct}
\alias{interpolate_spct}
\title{Map a spectrum to new wavelength values.}
\usage{
interpolate_spct(spct, w.length.out = NULL, fill = NA, length.out = NULL)

interpolate_mspct(mspct, w.length.out = NULL, fill = NA,
  length.out = NULL)
}
\arguments{
\item{spct}{generic_spct}

\item{w.length.out}{numeric array of wavelengths (nm)}

\item{fill}{a value to be assigned to out of range wavelengths}

\item{length.out}{numeric value}

\item{mspct}{an object of class "generic_mspct"}
}
\value{
A new spectral object of the same class as argument \code{spct}.
}
\description{
This function gives the result of interpolating spectral data from the original set of
wavelengths to a new one.
}
\details{
If \code{length.out} it is a numeric value, then gives the number of rows in the
output, if it is \code{NULL}, the values in the numeric vector \code{w.length.out} are used.
If both are not \code{NULL} then the range of \code{w.length.out} and \code{length.out} are
used to generate a vector of wavelength. A value of \code{NULL} for \code{fill} prevents
extrapolation.
}
\note{
The default \code{fill = NA} fills extrpolated values with NA. Giving NULL as
argument for \code{fill} deletes wavelengths outside the input data range from the
returned spectrum. A numerical value can be also be provided as fill. This function calls
\code{interpolate_spectrum} for each non-wavelength column in the input spectra object.
}
\examples{

interpolate_spct(sun.spct, 400:500, NA)
interpolate_spct(sun.spct, 400:500, NULL)
interpolate_spct(sun.spct, seq(200, 1000, by=0.1), 0)
interpolate_spct(sun.spct, c(400,500), length.out=201)

}

