% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.clean.r
\name{clean}
\alias{clean}
\alias{clean.default}
\alias{clean.source_spct}
\alias{clean.filter_spct}
\alias{clean.reflector_spct}
\alias{clean.object_spct}
\alias{clean.response_spct}
\alias{clean.cps_spct}
\alias{clean.raw_spct}
\alias{clean.generic_spct}
\alias{clean.source_mspct}
\alias{clean.filter_mspct}
\alias{clean.reflector_mspct}
\alias{clean.response_mspct}
\alias{clean.cps_mspct}
\alias{clean.raw_mspct}
\alias{clean.generic_mspct}
\title{Clean (=replace) off-range values in a spectrum}
\usage{
clean(x, range, range.s.data, fill, ...)

\method{clean}{default}(x, range, range.s.data, fill, ...)

\method{clean}{source_spct}(x, range = x, range.s.data = c(0, NA),
  fill = range.s.data,
  unit.out = getOption("photobiology.radiation.unit", default =
  "energy"), ...)

\method{clean}{filter_spct}(x, range = x, range.s.data = NULL,
  fill = range.s.data, qty.out = getOption("photobiology.filter.qty",
  default = "transmittance"), ...)

\method{clean}{reflector_spct}(x, range = x, range.s.data = c(0, 1),
  fill = range.s.data, ...)

\method{clean}{object_spct}(x, range = x, range.s.data = c(0, 1),
  fill = range.s.data, ...)

\method{clean}{response_spct}(x, range = x, range.s.data = c(0, NA),
  fill = range.s.data,
  unit.out = getOption("photobiology.radiation.unit", default =
  "energy"), ...)

\method{clean}{cps_spct}(x, range = x, range.s.data = c(0, NA),
  fill = range.s.data, ...)

\method{clean}{raw_spct}(x, range = x, range.s.data = c(NA_real_,
  NA_real_), fill = range.s.data, ...)

\method{clean}{generic_spct}(x, range = x, range.s.data = c(NA_real_,
  NA_real_), fill = range.s.data, col.names, ...)

\method{clean}{source_mspct}(x, range = NULL, range.s.data = c(0, NA),
  fill = range.s.data,
  unit.out = getOption("photobiology.radiation.unit", default =
  "energy"), ..., .parallel = FALSE, .paropts = NULL)

\method{clean}{filter_mspct}(x, range = NULL, range.s.data = NULL,
  fill = range.s.data, qty.out = getOption("photobiology.filter.qty",
  default = "transmittance"), ..., .parallel = FALSE, .paropts = NULL)

\method{clean}{reflector_mspct}(x, range = NULL, range.s.data = c(0,
  1), fill = range.s.data, ..., .parallel = FALSE, .paropts = NULL)

\method{clean}{response_mspct}(x, range = NULL, range.s.data = c(0,
  NA), fill = range.s.data,
  unit.out = getOption("photobiology.radiation.unit", default =
  "energy"), ..., .parallel = FALSE, .paropts = NULL)

\method{clean}{cps_mspct}(x, range = NULL, range.s.data = c(0, NA),
  fill = range.s.data, ..., .parallel = FALSE, .paropts = NULL)

\method{clean}{raw_mspct}(x, range = NULL, range.s.data = c(0, NA),
  fill = range.s.data, ..., .parallel = FALSE, .paropts = NULL)

\method{clean}{generic_mspct}(x, range = x, range.s.data = c(NA_real_,
  NA_real_), fill = range.s.data, col.names, ..., .parallel = FALSE,
  .paropts = NULL)
}
\arguments{
\item{x}{an R object}

\item{range}{numeric vector of wavelengths}

\item{range.s.data}{numeric vector of length two giving the allowable
range for the spectral data.}

\item{fill}{numeric vector of length 1 or 2, giving the replacement
values to use at each extreme of the range.}

\item{...}{currently ignored}

\item{unit.out}{character string with allowed values "energy", and "photon",
or its alias "quantum"}

\item{qty.out}{character string with allowed values "energy", and "photon",
or its alias "quantum"}

\item{col.names}{character The name of the variable to clean}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A copy of \code{x}, possibly with some of the spectral data values
  replaced by the value passed to \code{fill}.
}
\description{
These functions implement the equivalent of replace() but for spectral
objects instead of vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Replace off-range values in a source spectrum

\item \code{filter_spct}: Replace off-range values in a filter spectrum

\item \code{reflector_spct}: Replace off-range values in a reflector spectrum

\item \code{object_spct}: Replace off-range values in an object spectrum

\item \code{response_spct}: Replace off-range values in a response spectrum

\item \code{cps_spct}: Replace off-range values in a counts per second spectrum

\item \code{raw_spct}: Replace off-range values in a raw counts spectrum

\item \code{generic_spct}: Replace off-range values in a generic spectrum

\item \code{source_mspct}: 

\item \code{filter_mspct}: 

\item \code{reflector_mspct}: 

\item \code{response_mspct}: 

\item \code{cps_mspct}: 

\item \code{raw_mspct}: 

\item \code{generic_mspct}: 
}}

