% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.irradiance.r
\name{split_irradiance}
\alias{split_irradiance}
\title{Energy or photon irradiance for split spectrum regions}
\usage{
split_irradiance(w.length, s.irrad, cut.w.length = range(w.length),
  unit.out = getOption("photobiology.base.unit", default = "energy"),
  unit.in = "energy", scale = "absolute", check.spectrum = TRUE,
  use.cached.mult = FALSE, use.hinges = getOption("photobiology.use.hinges",
  default = NULL))
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm).}

\item{s.irrad}{numeric vector of spectral (energy or photon) irradiances
(W m-2 nm-1) or (mol s-1 m-2 nm-1).}

\item{cut.w.length}{numeric Vector of wavelengths (nm).}

\item{unit.out}{character Allowed values "energy", and "photon",
or its alias "quantum".}

\item{unit.in}{character Allowed values "energy", and "photon",
or its alias "quantum".}

\item{scale}{a character A string indicating the scale used for the returned
values ("absolute", "relative", "percent").}

\item{check.spectrum}{logical Flag indicating whether to sanity check input data,
default is TRUE.}

\item{use.cached.mult}{logical Flag indicating whether multiplier values should be
cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
A numeric vector of irradiances with no change in scale factor: [W m-2
  nm-1] -> [mol s-1 m-2] or [mol s-1 m-2 nm-1] -> [mol s-1 m-2] or relative
  values (as fraction of one if \code{scale == "relative"} or percentages
  if \code{scale == "percent"}.
}
\description{
This function returns the energy or photon irradiance for a series of
contiguous wavebands from a radiation spectrum. The returned values can be
either absolute or relative to their sum.
}
\note{
The last three parameters control speed optimizations. The defaults
  should be suitable in most cases. If you set \code{check.spectrum=FALSE}
  then you should call \code{\link{check_spectrum}} at least once for your
  spectrum before using any of the other functions. If you will use
  repeatedly the same SWFs on many spectra measured at exactly the same
  wavelengths you may obtain some speed up by setting
  \code{use.cached.mult=TRUE}. However, be aware that you are responsible for
  ensuring that the wavelengths are the same in each call, as the only test
  done is for the length of the \code{w.length} vector.
}
\examples{
with(sun.data,
      split_irradiance(w.length, s.e.irrad,
                       cut.w.length = c(300, 400, 500, 600, 700),
                       unit.out = "photon"))
}
