% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.R
\name{color}
\alias{color}
\alias{color.default}
\alias{color.numeric}
\alias{color.list}
\alias{color.waveband}
\alias{color.source_spct}
\alias{color.source_mspct}
\title{Color of an object}
\usage{
color(x, ...)

\method{color}{default}(x, ...)

\method{color}{numeric}(x, type = "CMF", ...)

\method{color}{list}(x, short.names = TRUE, type = "CMF", ...)

\method{color}{waveband}(x, short.names = TRUE, type = "CMF", ...)

\method{color}{source_spct}(x, type = "CMF", ...)

\method{color}{source_mspct}(x, ..., idx = !is.null(names(x)))
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{type}{character telling whether "CMF", "CC", or "both" should be returned.}

\item{short.names}{logical indicating whether to use short or long names for
wavebands}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\description{
A function that returns the equivalent RGB color of an object such as a
spectrum or wavelength.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method (returns always "black").

\item \code{numeric}: Method that returns Color definitions corresponding to
numeric values representing a wavelengths in nm.

\item \code{list}: Method that returns Color of elements in a list.

\item \code{waveband}: Color at midpoint of a \code{\link{waveband}} object.

\item \code{source_spct}: 

\item \code{source_mspct}: 
}}

\note{
When \code{x} is a list but not a waveband, if a method  \code{color}
  is not available for the class of each element of the list, then
  \code{color.default} will be called.
}
\examples{
wavelengths <- c(300, 420, 500, 600, NA) # nanometres
color(wavelengths)
color(waveband(c(300,400)))
color(list(blue = waveband(c(400,480)), red = waveband(c(600,700))))
color(numeric())
color(NA_real_)

color(sun.spct)


}
