% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.rm.R
\name{na.omit}
\alias{na.omit}
\alias{na.omit.generic_spct}
\alias{na.omit.source_spct}
\alias{na.omit.response_spct}
\alias{na.omit.filter_spct}
\alias{na.omit.reflector_spct}
\alias{na.omit.object_spct}
\alias{na.omit.cps_spct}
\alias{na.omit.raw_spct}
\alias{na.omit.chroma_spct}
\alias{na.omit.generic_mspct}
\alias{na.exclude.generic_spct}
\alias{na.exclude.source_spct}
\alias{na.exclude.response_spct}
\alias{na.exclude.filter_spct}
\alias{na.exclude.reflector_spct}
\alias{na.exclude.object_spct}
\alias{na.exclude.cps_spct}
\alias{na.exclude.raw_spct}
\alias{na.exclude.chroma_spct}
\alias{na.exclude.generic_mspct}
\title{Handle Missing Values in Objects}
\usage{
\method{na.omit}{generic_spct}(object, na.action = "omit", fill = NULL, target.colnames, ...)

\method{na.omit}{source_spct}(object, na.action = "omit", fill = NULL, ...)

\method{na.omit}{response_spct}(object, na.action = "omit", fill = NULL, ...)

\method{na.omit}{filter_spct}(object, na.action = "omit", fill = NULL, ...)

\method{na.omit}{reflector_spct}(object, na.action = "omit", fill = NULL, ...)

\method{na.omit}{object_spct}(object, na.action = "omit", fill = NULL, ...)

\method{na.omit}{cps_spct}(object, na.action = "omit", fill = NULL, ...)

\method{na.omit}{raw_spct}(object, na.action = "omit", fill = NULL, ...)

\method{na.omit}{chroma_spct}(object, na.action = "omit", fill = NULL, ...)

\method{na.omit}{generic_mspct}(object, na.action = "omit", fill = NULL, ...)

\method{na.exclude}{generic_spct}(object, na.action = "exclude", fill = NULL, target.colnames, ...)

\method{na.exclude}{source_spct}(object, na.action = "exclude", fill = NULL, ...)

\method{na.exclude}{response_spct}(object, na.action = "exclude", fill = NULL, ...)

\method{na.exclude}{filter_spct}(object, na.action = "exclude", fill = NULL, ...)

\method{na.exclude}{reflector_spct}(object, na.action = "exclude", fill = NULL, ...)

\method{na.exclude}{object_spct}(object, na.action = "exclude", fill = NULL, ...)

\method{na.exclude}{cps_spct}(object, na.action = "exclude", fill = NULL, ...)

\method{na.exclude}{raw_spct}(object, na.action = "exclude", fill = NULL, ...)

\method{na.exclude}{chroma_spct}(object, na.action = "exclude", fill = NULL, ...)

\method{na.exclude}{generic_mspct}(object, na.action = "exclude", fill = NULL, ...)
}
\arguments{
\item{object}{an R object}

\item{na.action}{character One of "omit", "exclude" or "replace".}

\item{fill}{numeric Value used to replace NAs unless NULL, in which case
interpolation is attempted.}

\item{target.colnames}{character Vector of names for the target columns
to operate upon, if present in \code{object}.}

\item{...}{further arguments other special methods could require}
}
\description{
These methods are useful for dealing with NAs in e.g., \code{source_spct},
\code{response_spct}, \code{filter_spct} and \code{reflector_spct}.
}
\details{
If \code{na.omit} removes cases, the row numbers of the cases form
  the \code{"na.action"} attribute of the result, of class \code{"omit"}.

  \code{na.exclude} differs from \code{na.omit} only in the class of the
  "na.action" attribute of the result, which is \code{"exclude"}.
}
\note{
\code{na.fail} and \code{na.pass} do not require a specialisation
  for spectral objects. R's definitions work as expected with no need to
  override them. We do not define a method \code{na.replace}, just pass
  \code{"replace"} as argument. The current implementation replaces by
  interpolation only individual NAs which are flanked on both sides by
  valid data. Runs of multiple NAs con only replaced by a constant value
  passed through parameter \code{fill}.
}
\examples{
my_sun.spct <- sun.spct
my_sun.spct[3, "s.e.irrad"] <- NA
my_sun.spct[5, "s.q.irrad"] <- NA

head(my_sun.spct)

# rows omitted
zo <- na.omit(my_sun.spct)
head(zo)
na.action(zo)

# rows excluded
ze <- na.exclude(my_sun.spct)
head(ze)
na.action(ze)

# data in both rows replaced
zr <- na.omit(my_sun.spct, na.action = "replace")
head(zr)
na.action(zr)

}
\seealso{
\code{\link[stats]{na.fail}} and \code{\link[stats]{na.action}}
}
