% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnLCF.R
\name{lnLCF}
\alias{lnLCF}
\title{Calculate the -log likelihood of data within a model.}
\usage{
lnLCF(x, data, fixed.parameters = NULL, parallel = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{A named vector of parameters (mu, sd, mu_season, sd_season, a, p and OTN).}

\item{data}{CMR database formated using TableECFOCF().}

\item{fixed.parameters}{Parameters that are fixed.}

\item{parallel}{If TRUE, parallel computing in ECFOCF_f is used.}

\item{verbose}{if TRUE, show the parameters.}
}
\value{
Return the -log likelihood of data within a model.\cr
}
\description{
Calculate the -log likelihood of data within a model.\cr
}
\details{
lnLCF calculate the -log likelihood of data within a model.
}
\examples{
\dontrun{
library(phenology)
# Example
ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002)
lnLCF(x=c(mu=4.71768454279272, 
                         sd=1.075711951667, 
                         p=-1.79746277312909), 
                 data=ECFOCF_2002)


ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002, date0=as.Date("2002-01-01"))
fp <- rep(0, dim(ECFOCF_2002)[3])
names(fp) <- paste0("p.", formatC(1:(dim(ECFOCF_2002)[3]), width=2, flag="0"))
par <- c(mu1 = 0.6404831115214353, 
         sd1 = 0.69362774786433479, 
         mu2 = 5.6404831115214353, 
         sd2 = 5.69362774786433479, 
         mu_season = 12.6404831115214353, 
         sd_season = 1.69362774786433479, 
         OTN=1)
par <- c(par, fp[attributes(ECFOCF_2002)$table["begin"]:attributes(ECFOCF_2002)$table["end"]])
fixed.parameters <- c(p=-Inf)

lnLCF(x=par, data=ECFOCF_2002, fixed.parameters=fixed.parameters)
}

}
\seealso{
Other Model of Clutch Frequency: \code{\link{ECFOCF_f}},
  \code{\link{TableECFOCF}}, \code{\link{fitCF}},
  \code{\link{logLik.ECFOCF}}, \code{\link{plot.ECFOCF}},
  \code{\link{plot.TableECFOCF}}
}
\author{
Marc Girondot
}
