% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhenoGu.R
\name{PhenoGu}
\alias{PhenoGu}
\alias{PhenoGu.fFIT}
\alias{PhenoGu.default}
\title{Phenology extraction in GU method (GU)}
\usage{
PhenoGu(x, t, ...)

\method{PhenoGu}{fFIT}(x, t = NULL, analytical = FALSE, smoothed.spline = FALSE, ...)

\method{PhenoGu}{default}(x, t, der1, IsPlot = TRUE, ...)
}
\arguments{
\item{x}{numeric vector, or \code{fFIT} object returned by \code{\link[=curvefit]{curvefit()}}.}

\item{t}{\code{doy} vector, corresponding doy of vegetation index.}

\item{...}{other parameters to \code{\link[=PhenoGu.default]{PhenoGu.default()}} or \code{\link[=PhenoGu.fFIT]{PhenoGu.fFIT()}}}

\item{analytical}{If true, \code{numDeriv} package \code{grad} and \code{hess}
will be used; if false, \code{D1} and \code{D2} will be used.}

\item{smoothed.spline}{Whether apply \code{smooth.spline} first?}

\item{der1}{the first order difference}

\item{IsPlot}{whether to plot?}
}
\value{
A numeric vector, with the elements of:
\itemize{
\item \code{UD}: upturn date
\item \code{SD}: stabilisation date
\item \code{DD}: downturn date
\item \code{RD}: recession date
}
}
\description{
Phenology extraction in GU method (GU)
}
\examples{
# `doubleLog.Beck` simulate vegetation time-series
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
par  = c( mn  = 0.1 , mx  = 0.7 , sos = 50 , rsp = 0.1 , eos = 250, rau = 0.1)
y <- doubleLog.Beck(par, t)

methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fit <- curvefit(y, t, tout, methods)
x <- fit$model$AG # one model

par(mfrow = c(2, 2))
PhenoTrs(x)
PhenoDeriv(x)
PhenoGu(x)
PhenoKl(x)
}
\references{
\enumerate{
\item Gu, L., Post, W. M., Baldocchi, D. D., Black, T. A., Suyker, A. E., Verma,
S. B., … Wofsy, S. C. (2009). Characterizing the Seasonal Dynamics of
Plant Community Photosynthesis Across a Range of Vegetation Types. In A.
Noormets (Ed.), Phenology of Ecosystem Processes: Applications in Global
Change Research (pp. 35–58). New York, NY: Springer New York.
\doi{10.1007/978-1-4419-0026-5_2}
\item Filippa, G., Cremonese, E., Migliavacca, M., Galvagno, M., Forkel, M.,
Wingate, L., … Richardson, A. D. (2016). Phenopix: A R package for
image-based vegetation phenology. Agricultural and Forest Meteorology,
220, 141–150. \doi{10.1016/j.agrformet.2016.01.006}
}
}
