% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_goal.R
\name{f_goal}
\alias{f_goal}
\title{Goal function of fine curve fitting methods}
\usage{
f_goal(par, fun, y, t, pred, w, ylu, ...)
}
\arguments{
\item{par}{A vector of parameters}

\item{fun}{A curve fitting function, can be one of \code{doubleAG},
\code{doubleLog.Beck}, \code{doubleLog.Elmore}, \code{doubleLog.Gu},
\code{doubleLog.Klos}, \code{doubleLog.Zhang}, see \code{\link[=Logistic]{Logistic()}}
for details.}

\item{y}{Numeric vector, vegetation index time-series}

\item{t}{Numeric vector, \code{Date} variable}

\item{pred}{Numeric Vector, predicted values}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{ylu}{\verb{ymin, ymax}, which is used to force \code{ypred} in the
range of \code{ylu}.}

\item{...}{others will be ignored.}
}
\value{
RMSE Root Mean Square Error of curve fitting values.
}
\description{
Goal function of fine curve fitting methods
}
\examples{
library(phenofit)

par  = c( mn  = 0.1 , mx  = 0.7 , sos = 50 , rsp = 0.1 , eos = 250, rau = 0.1)
par0 = c( mn  = 0.15, mx  = 0.65, sos = 100, rsp = 0.12, eos = 200, rau = 0.12)

# simulate vegetation time-series
fFUN = doubleLog_Beck
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y    <- fFUN(par, t)

f_goal(par0, fFUN, y, t)
}
