% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phate.R
\name{ggplot.phate}
\alias{ggplot.phate}
\title{Convert a PHATE object to a data.frame for ggplot}
\usage{
\method{ggplot}{phate}(data, ...)
}
\arguments{
\item{data}{A fitted PHATE object}

\item{...}{Arguments for ggplot()}
}
\description{
Passes the embedding matrix to ggplot with column names PHATE1 and PHATE2
}
\examples{
if (reticulate::py_module_available("phate") && require(ggplot2)) {

# data(tree.data)
# We use a smaller tree to make examples run faster
data(tree.data.small)
phate.tree <- phate(tree.data.small$data)
ggplot(phate.tree, aes(x=PHATE1, y=PHATE2, color=tree.data.small$branches)) +
  geom_point()

}
}
