% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{check_parameters_near_bounds}
\alias{check_parameters_near_bounds}
\title{check_parameters_near_bounds}
\usage{
check_parameters_near_bounds(
  model,
  values,
  zero_limit = 0.001,
  significant_digits = 2
)
}
\arguments{
\item{model}{(Model) Pharmpy model object}

\item{values}{(array) Series of values with index a subset of parameter names.}

\item{zero_limit}{(numeric) maximum distance to 0 bounds}

\item{significant_digits}{(numeric) maximum distance to non-zero bounds in number of significant digits}
}
\value{
(data.frame) Logical Series with same index as values
}
\description{
Check if any estimated parameter value is close to its bounds
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
check_parameters_near_bounds(model, results$parameter_estimates)
}

}
