% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_pd_iiv}
\alias{add_pd_iiv}
\title{add_pd_iiv}
\usage{
add_pd_iiv(model, initial_estimate = 0.09)
}
\arguments{
\item{model}{(Model) Pharmpy model to add new IIVs to.}

\item{initial_estimate}{(numeric) Value of initial estimate of parameter. Default is 0.09}
}
\value{
(Model) Pharmpy model object
}
\description{
Adds IIVs to all PD parameters in :class:\code{pharmpy.model}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- set_direct_effect(model, 'emax')
model$statements$find_assignment("EC_50")
model <- add_pd_iiv(model)
model$statements$find_assignment("EC_50")
}
}
\seealso{
add_iiv

add_iov

remove_iiv

remove_iov
}
