% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{calculate_bic}
\alias{calculate_bic}
\title{calculate_bic}
\usage{
calculate_bic(model, type = NULL, modelfit_results = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model object}

\item{type}{(str) Type of BIC to calculate. Default is the mixed effects.}

\item{modelfit_results}{(ModelfitResults) Alternative results object. Default is to use the one in model}
}
\value{
(numeric) BIC of model fit
}
\description{
Calculate final BIC value assuming the OFV to be -2LL

Different variations of the BIC can be calculated:
\itemize{
\item | mixed (default)
| BIC = OFV + n_random_parameters * log(n_individuals) +
|       n_fixed_parameters * log(n_observations)
\item | fixed
| BIC = OFV + n_estimated_parameters * log(n_observations)
\item | random
| BIC = OFV + n_estimated_parameters * log(n_individals)
\item | iiv
| BIC = OFV + n_estimated_iiv_omega_parameters * log(n_individals)
}
}
\examples{
\dontrun{
model <- load_example_model("pheno")
calculate_bic(model)
calculate_bic(model, type='fixed')
calculate_bic(model, type='random')
calculate_bic(model, type='iiv')
}

}
