% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simon_admissible.R
\name{binom.design}
\alias{binom.design}
\title{The design function for Simon (admissible) two-stage design}
\usage{
binom.design(type = c("minimax","optimal","maxpower","admissible"), p0, p1,
signif.level=0.05, power.level=0.85, nmax=100, plot.out = FALSE)
}
\arguments{
\item{type}{the output types of design, choose from "minimax","optimal","admissible" and "maxpower"}

\item{p0}{undesirable response rate.}

\item{p1}{desirable response rate for treatment efficacy.}

\item{signif.level}{threshold for the probability of declaring drug desirable under p0.}

\item{power.level}{threshold for the probability of declaring drug desirable under p1.}

\item{nmax}{maximum total sample size}

\item{plot.out}{logical; if FALSE (default), do not output plot, otherwise, output a plot for  design selection.}
}
\value{
\item{boundset}{the boundaries set: \eqn{r_1} and \eqn{n_1} for first stage \eqn{r} and \eqn{n} for second stage}
}
\description{
Search criterion to find the Optimal, Minimax, Admissible and
Maximized power design stopping boundary and corresponding sample size
}
\examples{
binom.design(type = "admissible", p0 = 0.15, p1 = 0.3, signif.level = 0.05, power.level = 0.9,
plot.out = TRUE)
}
\references{
Simon, R. (1989).
\emph{Optimal two-stage designs for phase II clinical trials.}
\emph{Controlled clinical trials} \strong{10(1)}, 1-10.

Jung, S. H., Lee, T., Kim, K., & George, S. L. (2004).
\emph{Admissible two-stage designs for phase II cancer clinical trials.}
\emph{Statistics in medicine} \strong{23(4)}, 561-569.
}

