/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.io.images;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Formatter;
import net.sf.eps2pgf.Main;
import net.sf.eps2pgf.io.RandomAccessOutputStream;
import net.sf.eps2pgf.ps.Image;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.resources.colors.PSColor;
import net.sf.eps2pgf.ps.resources.filters.ASCII85Encode;
import net.sf.eps2pgf.ps.resources.filters.FlateEncode;

public final class EpsImageCreator {
    private EpsImageCreator() {
    }

    public static void writeImage(OutputStream outputStream, Image image, String string) throws IOException, PSError {
        RandomAccessOutputStream randomAccessOutputStream = new RandomAccessOutputStream(outputStream);
        EpsImageCreator.writeHeader(randomAccessOutputStream, image, string);
        EpsImageCreator.writeScaling(randomAccessOutputStream, image);
        EpsImageCreator.writeColorSpace(randomAccessOutputStream, image);
        EpsImageCreator.writeImageDict(randomAccessOutputStream, image);
        ASCII85Encode aSCII85Encode = new ASCII85Encode(randomAccessOutputStream, null);
        FlateEncode flateEncode = new FlateEncode((OutputStream)aSCII85Encode, null);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(flateEncode);
        EpsImageCreator.writeImageData(bufferedOutputStream, image);
        ((OutputStream)bufferedOutputStream).close();
        ((OutputStream)flateEncode).close();
        ((OutputStream)aSCII85Encode).close();
        randomAccessOutputStream.write("\n%%EOF");
        randomAccessOutputStream.close();
    }

    private static void writeHeader(RandomAccessOutputStream randomAccessOutputStream, Image image, String string) throws IOException {
        randomAccessOutputStream.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        randomAccessOutputStream.write("%%Creator: " + Main.getNameVersion() + "\n");
        randomAccessOutputStream.write("%%Title: " + string + "\n");
        randomAccessOutputStream.write("%%CreationDate: ");
        Calendar calendar = Calendar.getInstance();
        Formatter formatter = new Formatter();
        formatter.format("%1$tY-%1$tm-%1$td %1$tk:%1$tM:%1$tS\n", calendar);
        randomAccessOutputStream.write(formatter.toString());
        randomAccessOutputStream.write("%%LanguageLevel: 3\n");
        double d = image.getOutputWidthPt();
        double d2 = image.getOutputHeightPt();
        randomAccessOutputStream.write("%%BoundingBox: 0 0 " + (int)Math.ceil(d));
        randomAccessOutputStream.write(" " + (int)Math.ceil(d2) + "\n");
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        randomAccessOutputStream.write("%%HiResBoundingBox: 0.0 0.0 " + decimalFormat.format(d) + " " + decimalFormat.format(d2));
        randomAccessOutputStream.write("\n%%EndComments\n\n");
    }

    private static void writeScaling(RandomAccessOutputStream randomAccessOutputStream, Image image) throws IOException {
        double d = image.getOutputWidthPt();
        double d2 = image.getOutputHeightPt();
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        randomAccessOutputStream.write(decimalFormat.format(d));
        randomAccessOutputStream.write(" ");
        randomAccessOutputStream.write(decimalFormat.format(d2));
        randomAccessOutputStream.write(" scale\n");
    }

    private static void writeColorSpace(RandomAccessOutputStream randomAccessOutputStream, Image image) throws PSErrorUnimplemented, IOException {
        PSColor pSColor = image.getColorSpace();
        randomAccessOutputStream.write(pSColor.getColorSpace().isis());
        randomAccessOutputStream.write(" setcolorspace\n");
    }

    private static void writeImageDict(RandomAccessOutputStream randomAccessOutputStream, Image image) throws IOException {
        randomAccessOutputStream.write("<<\n");
        randomAccessOutputStream.write("/ImageType 1\n");
        int n = image.getOutputWidthPx();
        randomAccessOutputStream.write(String.format("/Width %d\n", n));
        int n2 = image.getOutputHeightPx();
        randomAccessOutputStream.write(String.format("/Height %d\n", n2));
        randomAccessOutputStream.write(String.format("/ImageMatrix [%d 0 0 %d 0 0]\n", n, n2));
        randomAccessOutputStream.write(String.format("/BitsPerComponent %d\n", image.getBitsPerComponent()));
        double[] dArray = image.getDecode();
        randomAccessOutputStream.write("/Decode [");
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == (double)Math.round(dArray[i])) {
                randomAccessOutputStream.write(" " + (int)dArray[i]);
                continue;
            }
            randomAccessOutputStream.write(" " + dArray[i]);
        }
        randomAccessOutputStream.write(" ]\n");
        randomAccessOutputStream.write("/Interpolate " + image.getInterpolate() + "\n");
        randomAccessOutputStream.write("/DataSource currentfile /ASCII85Decode filter /FlateDecode filter\n");
        randomAccessOutputStream.write(">>\nimage\n");
    }

    public static void writeImageData(OutputStream outputStream, Image image) throws IOException, PSError {
        int n = image.getOutputWidthPx();
        int n2 = image.getOutputHeightPx();
        int n3 = image.getBitsPerComponent();
        int n4 = image.getColorSpace().getNrInputValues();
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7;
            for (n7 = 0; n7 < n; ++n7) {
                int[] nArray = image.getPixelInputIntValues(n7, i);
                for (int j = 0; j < n4; ++j) {
                    n5 <<= n3;
                    n6 += n3;
                    n6 = EpsImageCreator.writeBytesFromBuffer(outputStream, n5 |= nArray[j], n6);
                }
            }
            if (n6 <= 0) continue;
            n7 = 8 - n6;
            n6 += n7;
            n6 = EpsImageCreator.writeBytesFromBuffer(outputStream, n5 <<= n7, n6);
        }
    }

    private static int writeBytesFromBuffer(OutputStream outputStream, int n, int n2) throws IOException {
        int n3;
        for (n3 = n2; n3 >= 8; n3 -= 8) {
            int n4 = 0xFF & n >> n3 - 8;
            outputStream.write(n4);
        }
        return n3;
    }
}

