/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.io;

import java.io.IOException;
import java.io.InputStream;

public class StringInputStream
extends InputStream {
    private StringBuffer string;
    private int lastMark = 0;
    private int ptr = 0;

    public StringInputStream(String string) {
        this.string = new StringBuffer(string);
    }

    public int available() {
        return this.string.length() - this.ptr;
    }

    public void mark(int n) {
        this.lastMark = this.ptr;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        char c;
        try {
            c = this.string.charAt(this.ptr);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
        if (c > '\u00ff') {
            throw new IOException();
        }
        ++this.ptr;
        return c;
    }

    public void reset() {
        this.ptr = this.lastMark;
    }

    public long skip(long l) {
        long l2 = l;
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l3 = Math.min(l2, (long)(this.string.length() - this.ptr));
        this.ptr = (int)((long)this.ptr + l3);
        return l3;
    }
}

