/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectReal;

public class PSObjectInt
extends PSObject {
    private int value;

    public PSObjectInt(int n) {
        this.value = n;
    }

    public PSObjectInt(double d) {
        this.value = (int)Math.round(d);
    }

    public PSObjectInt(String string) throws PSErrorTypeCheck {
        try {
            int n = string.indexOf("#");
            if (n < 0) {
                this.value = Integer.parseInt(string);
            } else {
                int n2 = Integer.parseInt(string.substring(0, n));
                String string2 = string.substring(n + 1);
                this.value = Integer.parseInt(string2, n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSErrorTypeCheck();
        }
    }

    public PSObjectInt(PSObjectInt pSObjectInt) {
        this.value = pSObjectInt.value;
        this.copyCommonAttributes(pSObjectInt);
    }

    public String isis() {
        return String.valueOf(this.value);
    }

    public PSObject abs() {
        if (this.value == Integer.MIN_VALUE) {
            double d = this.value;
            return new PSObjectReal(Math.abs(d));
        }
        return new PSObjectInt(Math.abs(this.value));
    }

    public PSObject add(PSObject pSObject) throws PSErrorTypeCheck {
        if (pSObject instanceof PSObjectReal) {
            return pSObject.add(this);
        }
        int n = pSObject.toInt();
        if (this.value >= 0x3FFFFFFF || n >= 0x3FFFFFFF || this.value <= -1073741824 || n <= -1073741824) {
            double d = this.toReal();
            double d2 = pSObject.toReal();
            return new PSObjectReal(d + d2);
        }
        return new PSObjectInt(this.value + n);
    }

    public PSObjectInt and(PSObject pSObject) throws PSErrorTypeCheck {
        int n = pSObject.toInt();
        return new PSObjectInt(this.value & n);
    }

    public PSObjectInt ceiling() {
        return new PSObjectInt(this.value);
    }

    public PSObjectInt clone() {
        PSObjectInt pSObjectInt = (PSObjectInt)super.clone();
        return pSObjectInt;
    }

    public int cvi() {
        return this.value;
    }

    public double cvr() {
        return this.toReal();
    }

    public String cvrs(int n) throws PSErrorTypeCheck, PSErrorRangeCheck {
        if (n < 2) {
            throw new PSErrorRangeCheck();
        }
        if (this.value >= 0 || n == 10) {
            return Integer.toString(this.value, n).toUpperCase();
        }
        double d = Math.pow(2.0, 32.0) + (double)this.value;
        return Long.toString((long)d, n).toUpperCase();
    }

    public String cvs() {
        return String.valueOf(this.value);
    }

    public PSObjectInt dup() {
        return new PSObjectInt(this);
    }

    public boolean eq(PSObject pSObject) {
        try {
            if (pSObject instanceof PSObjectInt) {
                return this.value == pSObject.toInt();
            }
            if (pSObject instanceof PSObjectReal) {
                return this.toReal() == pSObject.toReal();
            }
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof PSObject) {
            return this.eq((PSObject)object);
        }
        return false;
    }

    public PSObjectInt floor() {
        return new PSObjectInt(this.value);
    }

    public boolean gt(PSObject pSObject) throws PSErrorTypeCheck {
        return this.toReal() > pSObject.toReal();
    }

    public int hashCode() {
        return this.value * 1000000;
    }

    public static boolean isType(String string) {
        try {
            new PSObjectInt(string);
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            return false;
        }
        return true;
    }

    public PSObject mul(PSObject pSObject) throws PSErrorTypeCheck {
        if (pSObject instanceof PSObjectReal) {
            double d = pSObject.toReal();
            double d2 = this.toReal();
            return new PSObjectReal(d2 * d);
        }
        int n = pSObject.toInt();
        int n2 = Math.max(Math.abs(this.value), Math.abs(n));
        int n3 = Math.min(Math.abs(this.value), Math.abs(n));
        if (n3 != 0 && n2 >= Integer.MAX_VALUE / n3) {
            double d = pSObject.toReal();
            double d3 = this.toReal();
            return new PSObjectReal(d3 * d);
        }
        return new PSObjectInt(this.value * n);
    }

    public PSObject neg() {
        if (this.value == Integer.MIN_VALUE) {
            double d = this.value;
            return new PSObjectReal(-d);
        }
        return new PSObjectInt(-this.value);
    }

    public PSObjectInt not() {
        return new PSObjectInt(~this.value);
    }

    public PSObjectInt or(PSObject pSObject) throws PSErrorTypeCheck {
        int n = pSObject.toInt();
        return new PSObjectInt(this.value | n);
    }

    public PSObjectInt round() {
        return new PSObjectInt(this.value);
    }

    public PSObject sub(PSObject pSObject) throws PSErrorTypeCheck {
        if (pSObject instanceof PSObjectReal) {
            double d = this.toReal();
            double d2 = pSObject.toReal();
            return new PSObjectReal(d - d2);
        }
        int n = pSObject.toInt();
        if (this.value >= 0x3FFFFFFF || n >= 0x3FFFFFFF || this.value <= -1073741824 || n <= -1073741824) {
            double d = this.toReal();
            double d3 = pSObject.toReal();
            return new PSObjectReal(d - d3);
        }
        return new PSObjectInt(this.value - n);
    }

    public String toDictKey() throws PSErrorTypeCheck {
        return Integer.toString(this.value);
    }

    public String toString() {
        return "Int: " + this.value;
    }

    public int toInt() {
        return this.value;
    }

    public double toReal() {
        return this.value;
    }

    public PSObjectInt truncate() {
        return new PSObjectInt(this.value);
    }

    public String type() {
        return "integertype";
    }

    public PSObjectInt xor(PSObject pSObject) throws PSErrorTypeCheck {
        int n = pSObject.toInt();
        return new PSObjectInt(this.value ^ n);
    }
}

