% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfocal_fast.R
\name{pfocal_fast_gaussian_radius}
\alias{pfocal_fast_gaussian_radius}
\alias{pfocal_fast_gaussian_confidence}
\alias{pfocal_fast_binomial}
\alias{pfocal_fast_abs_rectangle}
\alias{pfocal_fast_separated}
\title{Fast methods for common kernel computations}
\usage{
pfocal_fast_gaussian_radius(
  data,
  vertical_radius,
  vertical_sd = 1,
  horizontal_radius = vertical_radius,
  horizontal_sd = vertical_sd,
  tail_included = TRUE,
  na.rm = NA,
  mp = TRUE,
  debug_use_r_implementation = FALSE,
  ...,
  transform_function = "MULTIPLY",
  reduce_function = "SUM",
  mean_divider = "ONE",
  variance = FALSE
)

pfocal_fast_gaussian_confidence(
  data,
  vertical_r0 = 0.05,
  vertical_sd = 1,
  horizontal_r0 = vertical_r0,
  horizontal_sd = vertical_sd,
  tail_included = TRUE,
  na.rm = NA,
  mp = TRUE,
  debug_use_r_implementation = FALSE,
  ...,
  transform_function = "MULTIPLY",
  reduce_function = "SUM",
  mean_divider = "ONE",
  variance = FALSE
)

pfocal_fast_binomial(
  data,
  vertical_radius,
  horizontal_radius = vertical_radius,
  na.rm = NA,
  mp = TRUE,
  debug_use_r_implementation = FALSE,
  ...,
  transform_function = "MULTIPLY",
  reduce_function = "SUM",
  mean_divider = "ONE",
  variance = FALSE
)

pfocal_fast_abs_rectangle(
  data,
  height,
  width = height,
  value = 1,
  na.rm = NA,
  mp = TRUE,
  debug_use_r_implementation = FALSE,
  ...,
  transform_function = "MULTIPLY",
  reduce_function = "SUM",
  mean_divider = "ONE",
  variance = FALSE
)

pfocal_fast_separated(
  data,
  kernel_list,
  na.rm = NA,
  mp = TRUE,
  debug_use_r_implementation = FALSE,
  ...,
  transform_function = "MULTIPLY",
  reduce_function = "SUM",
  mean_divider = "ONE",
  variance = FALSE
)
}
\arguments{
\item{data}{\strong{[matrix-type]} Grid to compute onto.}

\item{vertical_radius}{\strong{[numeric]} The kernel's radius in the vertical
dimension.}

\item{vertical_sd}{\strong{[numeric]} The kernel's standard deviation in the
vertical dimension.}

\item{horizontal_radius}{\strong{[numeric]} The kernel's radius in the horizontal
dimension.}

\item{horizontal_sd}{\strong{[numeric]} The kernel's standard deviation in the
horizontal dimension.}

\item{tail_included}{\strong{[logical]} Whether or not to include the kernel
tail.}

\item{na.rm}{\strong{[NA OR logical]} The behavior to adopt for dealing with
missing values, default to \code{NA} (faster option). For possible values see
\code{\link[=pfocal_info_nan_policy]{pfocal_info_nan_policy()}}.}

\item{mp}{\strong{[logical]} Whether to use the open_mp implementation,
default to \code{TRUE}.}

\item{debug_use_r_implementation}{\strong{[logical]} Used for debugging purposes
whether to use the slow R implementation instead of the fast C++ code.
Default to \code{FALSE}.}

\item{...}{None used at the moment
.}

\item{transform_function}{\strong{[character]} The function to apply to the
cell values covered by the kernel. For possible values, see
\code{\link[=pfocal_info_transform]{pfocal_info_transform()}}. Default to \code{"MULTIPLY"}.}

\item{reduce_function}{\strong{[character]} The function to apply to the kernel
values after the function passed in \code{transform_function} has been applied
(the function that summarize the data). For possible values, see
\code{\link[=pfocal_info_reduce]{pfocal_info_reduce()}}. Default to \code{"SUM"}.}

\item{mean_divider}{\strong{[character]} Optional, allows to specify how the
final value at each cell is divided by a value that can be function of
the intermediate data resulting of applying \code{transform_function}. For
possible values, see \code{\link[=pfocal_info_mean_divisor]{pfocal_info_mean_divisor()}}. Default to "ONE" (for
no division).}

\item{variance}{\strong{[logical]} Whether to return the "variance" of the
intermediate values at each point (for more details please see
\code{\link[=pfocal_info_variance]{pfocal_info_variance()}}). Default to \code{FALSE} (just returns the value
at each point).}

\item{vertical_r0}{\strong{[numeric]} The kernel's r0 (exponential) in the
vertical dimension.}

\item{horizontal_r0}{\strong{[numeric]} The kernel's r0 (exponential) in the
horizontal dimension.}

\item{height}{\strong{[numeric]} For rectangular kernels, the height of the
rectangle.}

\item{width}{\strong{[numeric]} For rectangular kernels, the width of the
rectangle.}

\item{value}{\strong{[numeric]} For single value matrices, the value.}

\item{kernel_list}{\strong{[list]} A list of kernels computed from functions in
\link{kernel-gaussian}, \link{kernel-binomial}, \link{kernel-circular},
\link{kernel-distance}, \link{kernel-exponential}.}
}
\value{
The updated, convoluted grid.
}
\description{
Methods wrapping \link{pfocal} to implement common kernel computations with
default argument values.
}
\examples{

data <- matrix(nrow = 10, ncol = 10, data = runif(10 * 10))

pfocal_fast_gaussian_radius(data, vertical_radius = 2)
pfocal_fast_gaussian_confidence(data)
pfocal_fast_binomial(data, vertical_radius = 2)
pfocal_fast_abs_rectangle(data, height = 2)

pfocal_fast_separated(data, 
                      kernel_list = list(binomial_kernel(vertical_radius = 2, 
                                                         horizontal_radius = 2), 
                                         distance_kernel(vertical_radius = 2,
                                                         horizontal_radius = 2)))

}
