% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{pez.metrics}
\alias{pez.metrics}
\alias{.colless}
\alias{.hed}
\alias{.eed}
\alias{.psv}
\alias{.psr}
\alias{.mpd}
\alias{.vpd}
\alias{.vntd}
\alias{.pd}
\alias{.mntd}
\alias{.gamma}
\alias{.taxon}
\alias{.eigen.sum}
\alias{.dist.fd}
\alias{.sqrt.phy}
\alias{.phylo.entropy}
\alias{.aed}
\alias{.haed}
\alias{.simpson.phylogenetic}
\alias{.iac}
\alias{.pae}
\alias{.scheiner}
\alias{.pse}
\alias{.rao}
\alias{.lambda}
\alias{.delta}
\alias{.kappa}
\alias{.eaed}
\alias{.unifrac}
\alias{.pcd}
\alias{.comdist}
\alias{.phylosor}
\alias{.d}
\alias{.ses.mpd}
\alias{.ses.mntd}
\alias{.ses.vpd}
\alias{.ses.vntd}
\alias{.ses.mipd}
\alias{.ses.innd}
\alias{.mipd}
\alias{.innd}
\alias{.pe}
\alias{.bed}
\title{Phylogenetic and functional trait metrics within pez}
\usage{
.colless(x, ...)

.hed(x, ...)

.eed(x, na.rm = TRUE, ...)

.psv(x, ...)

.psr(x, ...)

.mpd(x, dist = NULL, abundance.weighted = FALSE, ...)

.vpd(x, dist = NULL, abundance.weighted = FALSE, ...)

.vntd(x, dist = NULL, abundance.weighted = FALSE, ...)

.pd(x, include.root = TRUE, abundance.weighted = FALSE, ...)

.mntd(x, dist = NULL, abundance.weighted = FALSE, ...)

.gamma(x, ...)

.taxon(x, dist = NULL, abundance.weighted = FALSE, ...)

.eigen.sum(x, dist = NULL, which.eigen = 1, ...)

.dist.fd(x, method = "phy", abundance.weighted = FALSE, ...)

.sqrt.phy(x)

.phylo.entropy(x, ...)

.aed(x, ...)

.haed(x, ...)

.simpson.phylogenetic(x)

.iac(x, na.rm = TRUE, ...)

.pae(x, na.rm = TRUE, ...)

.scheiner(x, q = 0, abundance.weighted = FALSE, ...)

.pse(x, ...)

.rao(x, ...)

.lambda(x, ...)

.delta(x, ...)

.kappa(x, ...)

.eaed(x, ...)

.unifrac(x, ...)

.pcd(x, permute = 1000, ...)

.comdist(x, dist = NULL, abundance.weighted = FALSE, ...)

.phylosor(x, dist = NULL, abundance.weighted = FALSE, ...)

.d(x, permute = 1000, ...)

.ses.mpd(x, dist = NULL, null.model = "taxa.labels",
  abundance.weighted = FALSE, permute = 1000, ...)

.ses.mntd(x, dist = NULL, null.model = "taxa.labels",
  abundance.weighted = FALSE, permute = 1000, ...)

.ses.vpd(x, dist = NULL, null.model = "taxa.labels",
  abundance.weighted = FALSE, permute = 1000, ...)

.ses.vntd(x, dist = NULL, null.model = "taxa.labels",
  abundance.weighted = FALSE, permute = 1000, ...)

.ses.mipd(x, dist = NULL, null.model = "taxa.labels",
  abundance.weighted = FALSE, permute = 1000, ...)

.ses.innd(x, dist = NULL, null.model = "taxa.labels",
  abundance.weighted = FALSE, permute = 1000, ...)

.mipd(x, dist = NULL, abundance.weighted = FALSE, ...)

.innd(x, dist = NULL, abundance.weighted = FALSE, ...)

.innd(x, dist = NULL, abundance.weighted = FALSE, ...)

.pe(x, ...)

.bed(x, ...)
}
\arguments{
\item{x}{\code{\link{comparative.comm}} object}

\item{...}{ignored}

\item{na.rm}{remove NAs in calculations (altering this can obscure
errors that are meaningful; I would advise leaving alone)}

\item{dist}{distance matrix for use with calculations; could be
generated from traits, a square-root-transformed distance matrix
(see \code{\link{.sqrt.phy}} for creating a
\code{\link{comparative.comm}} object with a square-root
transformed phylogeny). Default: NULL (--> calculate distance
matrix from phylogeny)}

\item{abundance.weighted}{whether to include species' abundances in
metric calculation, often dictating whether you're calculating a
\code{\link{pez.shape}} or \code{\link{pez.evenness}}
metric. Default: FALSE}

\item{include.root}{include root in PD calculations (default is
TRUE, as in picante, but within \code{\link{pez.shape}} I specify
FALSE}

\item{which.eigen}{which phylo-eigenvector to be used for PVR
metric}

\item{method}{whether to calculate using phylogeny ("phy";
default) or trait data ("traits")}

\item{q}{the q parameter for \code{.scheiner}; default 0.0001}

\item{permute}{number of permutations of null randomisations
(mostly only applies to \code{\link[pez:pez.dispersion]{dispersion
metrics}})}

\item{null.model}{one of "taxa.labels", "richness", "frequency",
"sample.pool", "phylogeny.pool", "independentswap", or
"independentswap". These correspond to the null models available in
\code{\link{picante}}; only \code{d} does not use these null models}
}
\description{
Using these functions, you can calculate any of the phylogenetic
metrics within pez, using \code{\link{comparative.comm}}
objects. While you can call each individually, using the
\code{\link{pez.shape}}, \code{\link{pez.evenness}},
\code{\link{pez.dispersion}}, and \code{\link{pez.dissimilarity}}
wrapper functions (and the more flexible
\code{\link{generic.metrics}} and null model functions) are probably
your best bet. Note that *all of these functions* take a common
first parameter: a \code{\link{comparative.comm}} object. There are
additional parameters that can be passed, which are described
below.
}
\details{
\code{.pd} returns two metrics: Faith's PD (which does not take
into account abundance) and Faith's PD corrected for species
richness or total abundance (depending on
\code{abundance.weighted}). I am almost certain that I got the idea
for this from somewhere, but I can't find the reference: if you
published on this before 2012, please get in touch with me.

\code{.scheiner} has a different formula for the case where
\code{q} is equal to 1 (check the code if interested). The nature
of its definition means that values very close to, but not exactly
equal to, 1 may be extremely large or extremely small. This is a
feature, not a bug, and an inherent aspect of its definition. Check
the formula in the code for more information!
}
\note{
Many (but not all) of these functions are fairly trivial
wrappers around functions in other packages. In the citations for
each metric, * indicates a function that's essentially written in
\code{\link{picante}}. The Pagel family of measures are also fairly
trivial wrapper around \code{\link{caper}} code, functional
dissimilarity \code{\link{FD}} code, \code{gamma} \code{\link{ape}}
code, and \code{colless}
\code{\link[apTreeshape:colless]{apTreeshape}} code. I can't demand
it, but I would be grateful if you would cite these authors when
using these wrappers.

The \code{\link{pez.shape}}, \code{\link{pez.evenness}},
\code{\link{pez.dispersion}}, and \code{\link{pez.dissimilarity}}
wrapper functions go to some trouble to stop you calculating
metrics using inappropriate data (see their notes). These functions
give you access to the underlying code within \code{pez}; there is
nothing I can do to stop you calculating a metric that, in my
opinion, doesn't make any sense. You have been warned :D

If you're a developer hoping to make your metric(s) work in this
framework, please use the argument naming convention for arguments
described in this help file, and use the \code{...} operator in
your definition. That way functions that don't need particular
arguments can co-exist peacefully with those that do. The first
argument to one of these functions should \emph{always} be a
\code{\link{comparative.comm}} object; there is no method dispatch
on any of these functions and I foresee future pain without this
rule.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites)
.psv(data)
}
\references{
\code{colless} Colless D.H. (1982). Review of
phylogenetics: the theory and practice of phylogenetic
systematics. Systematic Zoology, 31, 100-104.

\code{eed,hed} (i.e., \emph{Eed, Hed}) Cadotte M.W.,
Davies T.J., Regetz J., Kembel S.W., Cleland E. & Oakley
T.H. (2010). Phylogenetic diversity metrics for ecological
communities: integrating species richness, abundance and
evolutionary history. Ecology Letters, 13, 96-105.

\code{PSV,PSR,PSE} Helmus M.R., Bland T.J., Williams
C.K. & Ives A.R. (2007). Phylogenetic measures of
biodiversity. American Naturalist, 169, E68-E83.

\code{PD} Faith D.P. (1992). Conservation evaluation
and phylogenetic diversity. Biological Conservation, 61, 1-10.

\code{gamma} Pybus O.G. & Harvey P.H. (2000) Testing
macro-evolutionary models using incomplete molecular
phylogenies. _Proceedings of the Royal Society of London. Series
B. Biological Sciences 267: 2267--2272.

\code{taxon} Clarke K.R. & Warwick R.M. (1998). A
taxonomic distinctness index and its statistical
properties. J. Appl. Ecol., 35, 523-531.

\code{eigen.sum} Diniz-Filho J.A.F., Cianciaruso M.V.,
Rangel T.F. & Bini L.M. (2011). Eigenvector estimation of
phylogenetic and functional diversity. Functional Ecology, 25,
735-744.

\code{entropy} Allen B., Kon M. & Bar-Yam Y. (2009). A
New Phylogenetic Diversity Measure Generalizing the Shannon Index
and Its Application to Phyllostomid Bats. The American Naturalist,
174, 236-243.

\code{pae,aed,iac,haed,eaed} Cadotte M.W., Davies T.J.,
Regetz J., Kembel S.W., Cleland E. & Oakley
T.H. (2010). Phylogenetic diversity metrics for ecological
communities: integrating species richness, abundance and
evolutionary history. Ecology Letters, 13, 96-105.

\code{scheiner} Scheiner, S.M. (20120). A metric of
biodiversity that integrates abundance, phylogeny, and function.
Oikos, 121, 1191-1202.

\code{rao} Webb C.O. (2000). Exploring the phylogenetic
structure of ecological communities: An example for rain forest
trees. American Naturalist, 156, 145-155.

\code{lambda,delta,kappa} Mark Pagel (1999) Inferring
the historical patterns of biological evolution. Nature 6756(401):
877--884.

\code{unifrac} Lozupone C.A. & Knight
R. (2005). UniFrac: a new phylogenetic method for comparing
microbial communities. Applied and Environmental Microbiology, 71,
8228-8235.

\code{pcd} Ives A.R. & Helmus M.R. (2010). Phylogenetic
metrics of community similarity. The American Naturalist, 176,
E128-E142.

\code{comdist} C.O. Webb, D.D. Ackerly, and
S.W. Kembel. 2008. Phylocom: software for the analysis of
phylogenetic community structure and trait
evolution. Bioinformatics 18:2098-2100.

\code{phylosor} Bryant J.A., Lamanna C., Morlon H.,
Kerkhoff A.J., Enquist B.J. & Green J.L. (2008). Microbes on
mountainsides: Contrasting elevational patterns of bacterial and
plant diversity. Proceedings of the National Academy of Sciences of
the United States of America, 105, 11505-11511.

\code{d} Fritz S.A. & Purvis A. (2010). Selectivity in
Mammalian Extinction Risk and Threat Types: a New Measure of
Phylogenetic Signal Strength in Binary Traits. Conservation
Biology, 24, 1042-1051.

\code{sesmpd,sesmntd} Webb C.O. (2000). Exploring the
phylogenetic structure of ecological communities: An example for
rain forest trees. American Naturalist, 156, 145-155.

\code{innd,mipd} Ness J.H., Rollinson E.J. & Whitney
K.D. (2011). Phylogenetic distance can predict susceptibility to
attack by natural enemies. Oikos, 120, 1327-1334.

\code{PE} Rosauer, D. A. N., Laffan, S. W., Crisp,
    M. D., Donnellan, S. C., & Cook, L. G. (2009). Phylogenetic
    endemism: a new approach for identifying geographical
    concentrations of evolutionary history. Molecular Ecology,
    18(19), 4061-4072.

\code{BED} Cadotte, M. W., & Jonathan Davies,
    T. (2010). Rarest of the rare: advances in combining
    evolutionary distinctiveness and scarcity to inform
    conservation at biogeographical scales. Diversity and
    Distributions, 16(3), 376-385.
}
