% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perryPlot.R
\name{perryPlot}
\alias{perryPlot}
\alias{perryPlot.perry}
\alias{perryPlot.perrySelect}
\alias{perryPlot.setupPerryPlot}
\alias{autoplot.perry}
\alias{autoplot.perrySelect}
\alias{plot.perry}
\alias{plot.perrySelect}
\title{Plot resampling-based prediction error results}
\usage{
perryPlot(object, ...)

\method{perryPlot}{perry}(
  object,
  which = c("box", "density", "dot"),
  select = NULL,
  seFactor = NA,
  ...
)

\method{perryPlot}{perrySelect}(
  object,
  which = c("box", "density", "dot", "line"),
  subset = NULL,
  select = NULL,
  seFactor = object$seFactor,
  ...
)

\method{perryPlot}{setupPerryPlot}(object, mapping = object$mapping, facets = object$facets, ...)

\method{autoplot}{perry}(object, ...)

\method{autoplot}{perrySelect}(object, ...)

\method{plot}{perry}(x, ...)

\method{plot}{perrySelect}(x, ...)
}
\arguments{
\item{object, x}{an object inheriting from class \code{"perry"} or
\code{"perrySelect"} that contains prediction error results, or an object of
class \code{"setupPerryPlot"} containing all necessary information for
plotting (as generated by \code{\link{setupPerryPlot}}).}

\item{\dots}{additional arguments to be passed down, eventually to
\code{\link[ggplot2]{geom_boxplot}}, \code{\link[ggplot2]{geom_density}},
\code{\link[ggplot2]{geom_pointrange}}, or \code{\link[ggplot2]{geom_line}}.}

\item{which}{a character string specifying the type of plot.  Possible
values are \code{"box"} to create a box plot, \code{"density"} to create a
smooth density plot, \code{"dot"} to create a dot plot, or \code{"line"} to
plot the (average) results for each model as a connected line (for objects
inheriting from class \code{"perrySelect"}).  Note that the first two plots
are only meaningful in case of repeated resampling.  The default is to use
\code{"box"} in case of repeated resampling and \code{"dot"} otherwise.}

\item{select}{a character, integer or logical vector indicating the columns
of prediction error results to be plotted.}

\item{seFactor}{a numeric value giving the multiplication factor of the
standard error for displaying error bars in dot plots or line plots.  Error
bars in those plots can be suppressed by setting this to \code{NA}.}

\item{subset}{a character, integer or logical vector indicating the subset
of models for which to plot the prediction error results.}

\item{mapping}{an aesthetic mapping to override the default behavior (see
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}).}

\item{facets}{a faceting formula to override the default behavior.  If
supplied, \code{\link[ggplot2]{facet_wrap}} or
\code{\link[ggplot2]{facet_grid}} is called depending on whether the formula
is one-sided or two-sided.}
}
\value{
An object of class \code{"ggplot"} (see \code{\link[ggplot2]{ggplot}}).
}
\description{
Plot results of resampling-based prediction error measures.
}
\details{
For objects with multiple columns of prediction error results, conditional
plots are produced.
}
\note{
Duplicate indices in \code{subset} or \code{select} are removed such
that all models and prediction error results are unique.
}
\seealso{
\code{\link{setupPerryPlot}},

\code{\link{perryFit}}, \code{\link{perrySelect}},
\code{\link{perryTuning}},

\code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{autoplot}},
\code{\link[graphics]{plot}}
}
\author{
Andreas Alfons
}
\keyword{hplot}
