% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discoverability.R
\name{perm.glmer}
\alias{perm.glmer}
\title{A general permutation test for mixed-effects models or other \code{buildmer} models. This is an alias for \code{perm.lmer} provided for discoverability.}
\usage{
perm.glmer(...)
}
\arguments{
\item{...}{Arguments to be passed to \code{perm.lmer}.}
}
\description{
A general permutation test for mixed-effects models or other \code{buildmer} models. This is an alias for \code{perm.lmer} provided for discoverability.
}
\examples{
\donttest{
# Testing a single EEG electrode, with random effects by participants
perms <- perm.glmer(Fz ~ Deviant * Session + (Deviant * Session | Subject),data=MMN)
# Testing a single EEG electrode, with random effects by participants, ANOVA inference
perms <- perm.glmer(Fz ~ Deviant * Session + (Deviant * Session | Subject),data=MMN,type='anova')
}
\dontshow{
perms <- perm.glmer(Fz ~ Deviant*Session + (1|Subject),data=MMN[MMN$Time > 200 & MMN$Time < 205,],nperm=2,type='anova')
perms <- perm.glmer(Fz ~ Deviant*Session + (1|Subject),data=MMN[MMN$Time > 200 & MMN$Time < 205,],nperm=2,type='regression')
perms <- perm.glmer(Fz ~ Session + (1|Subject),data=within(MMN[MMN$Time > 200 & MMN$Time < 205,],{Session <- factor(Session)}),nperm=2,type='regression')
}
}
\seealso{
perm.lmer
}
