% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_logloss.R
\name{performance_logloss}
\alias{performance_logloss}
\title{Log Loss}
\usage{
performance_logloss(model, verbose = TRUE, ...)
}
\arguments{
\item{model}{Model with binary outcome.}

\item{verbose}{Toggle off warnings.}

\item{...}{Currently not used.}
}
\value{
Numeric, the log loss of \code{model}.
}
\description{
Compute the log loss for models with binary outcome.
}
\details{
Logistic regression models predict the probability of an outcome of
  being a "success" or "failure" (or 1 and 0 etc.). \code{performance_logloss()} evaluates
  how good or bad the predicted probabilities are. High values indicate
  bad predictions, while low values indicate good predictions. The lower
  the log-loss, the better the model predicts the outcome.
}
\examples{
data(mtcars)
m <- glm(formula = vs ~ hp + wt, family = binomial, data = mtcars)
performance_logloss(m)
}
\seealso{
\code{\link[=performance_score]{performance_score()}}
}
