% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.bayesian.R
\name{model_performance.stanreg}
\alias{model_performance.stanreg}
\title{Performance of Bayesian Models}
\usage{
\method{model_performance}{stanreg}(model, metrics = "all", ...)
}
\arguments{
\item{model}{Object of class \code{stanreg} or \code{brmsfit}.}

\item{metrics}{Can be \code{"all"} or a character vector of metrics to be computed (some of \code{c("LOOIC", "WAIC", "R2", "R2_adj", "RMSE", "LOGLOSS", "SCORE")}).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame (with one row) and one column per "index" (see \code{metrics}).
}
\description{
Compute indices of model performance for (general) linear models.
}
\details{
See 'Details' in \code{\link{model_performance.lm}} for more
details on returned indices.
}
\examples{
library(rstanarm)

model <- stan_glm(mpg ~ wt + cyl, data = mtcars, chains = 1, iter = 500)
model_performance(model)

model <- stan_glmer(
  mpg ~ wt + cyl + (1 | gear),
  data = mtcars,
  chains = 1,
  iter = 500
)
model_performance(model)

}
\references{
Gelman, A., Goodrich, B., Gabry, J., & Vehtari, A. (2018). R-squared for Bayesian regression models. The American Statistician, The American Statistician, 1-6.
}
\seealso{
\link{r2_bayes}
}
