% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional-options.R
\name{initest_options}
\alias{initest_options}
\title{Additional Options for the Initial Estimator}
\usage{
initest_options(keep_solutions = 5, psc_method = c("exact", "rr"),
  maxit = 10, maxit_pense_refinement = 5, eps = 1e-06,
  psc_keep = 0.5, resid_keep_method = c("proportion", "threshold"),
  resid_keep_prop = 0.6, resid_keep_thresh = 2, mscale_eps = 1e-08,
  mscale_maxit = 200)
}
\arguments{
\item{keep_solutions}{how many initial estimates should be kept to perform
full PENSE iterations?}

\item{psc_method}{The method to use for computing the principal sensitivity
components. See details for the possible choices.}

\item{maxit}{maximum number of refinement iterations.}

\item{maxit_pense_refinement}{maximum number of PENSE iterations to refine
initial estimator.}

\item{eps}{numeric tolerance for convergence.}

\item{psc_keep}{proportion of observations to keep based on the PSC scores.}

\item{resid_keep_method}{How to clean the data based on large residuals.
If \code{"proportion"}, observations with the smallest
\code{resid_keep_prop} residuals will be retained.
If \code{"threshold"}, all observations with scaled residuals smaller
than the threshold \code{resid_keep_thresh} will be retained.}

\item{resid_keep_prop, resid_keep_thresh}{proportion or threshold for
observations to keep based on their residual.}

\item{mscale_eps, mscale_maxit}{maximum number of iterations and numeric
tolerance for the M-scale.}
}
\value{
a checked options list.
}
\description{
Specify additional options for the initial estimator based on the Pena-Yohai
estimator.
}
\details{
Two different methods to calculate the sensitivity components are
implemented:
\describe{
     \item{\code{"rr"}}{Approximate the PSCs by using the residuals from the
         elastic net fit and the hat matrix from the ridge regression.
         This method only works if \code{alpha} < 1 or
         \code{ncol(x)} < \code{nrow(x)}.}
     \item{\code{"exact"}}{Calculate the PSCs from the difference between the
         residuals and leave-one-out residuals from elastic net.}
}
}
\references{
Pena, D., & Yohai, V.. (1999). A Fast Procedure for Outlier
Diagnostics in Large Regression Problems. \emph{Journal of the American
Statistical Association}, 94(446), 434-445.
\url{http://doi.org/10.2307/2670164}
}
\seealso{
Other specifying additional options: \code{\link{en_options_aug_lars}},
  \code{\link{mstep_options}}, \code{\link{pense_options}}
}
\concept{specifying additional options}
