% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_prclmm_data.R
\name{simulate_prclmm_data}
\alias{simulate_prclmm_data}
\title{Simulate data that can be used to fit the PRC-LMM model}
\usage{
simulate_prclmm_data(n = 100, p = 10, p.relev = 4, lambda = 0.2,
  nu = 2, seed = 1, base.age.range = c(3, 5), cens.range = c(0.5, 10),
  t.values = c(0, 0.5, 1, 2))
}
\arguments{
\item{n}{sample size}

\item{p}{number of longitudinal outcomes}

\item{p.relev}{number of longitudinal outcomes that
are associated with the survival outcome (min: 1, max: p)}

\item{lambda}{Weibull location parameter, positive}

\item{nu}{Weibull scale parameter, positive}

\item{seed}{random seed (defaults to 1)}

\item{base.age.range}{range for age at baseline (set it
equal to c(0, 0) if you want all subjects to enter
the study at the same age)}

\item{cens.range}{range for censoring times}

\item{t.values}{vector specifying the time points 
at which longitudinal measurements are collected
(NB: for simplicity, this function assumes a balanced 
designed; however, \code{pencal} is designed to work
both with balanced and with unbalanced designs!)}
}
\value{
A list containing the following elements:
\itemize{
\item a dataframe \code{long.data} with data on the longitudinal 
predictors, comprehensive of a subject id (\code{id}),
baseline age (\code{base.age}),time from baseline
(\code{t.from.base}) and the longitudinal biomarkers;
\item a dataframe \code{surv.data} with the survival data: 
a subject id (\code{id}), baseline age (\code{baseline.age}),
the time to event outcome (\code{time}) and a binary vector
(\code{event}) that is 1 if the event
is observed, and 0 in case of right-censoring;
\item \code{perc.cens} the proportion of censored individuals 
in the simulated dataset.
}
}
\description{
This function allows to simulate a survival outcome
from longitudinal predictors. Specifically, the longitudinal
predictors are simulated from linear mixed models (LMMs), and 
the survival outcome from a Weibull model where the time
to event depends on the random effects from the LMMs.
It is an implementation of the simulation method used in
Signorelli et al. (2020, in review)
}
\examples{
# generate example data
simdata = simulate_prclmm_data(n = 20, p = 10, 
                        p.relev = 4, seed = 1)
# view the longitudinal markers:
library(ptmixed)
make.spaghetti(x = age, y = marker1, 
               id = id, group = id,
               data = simdata$long.data, 
               legend.inset = - 1)
# proportion of censored subjects
simdata$censoring.prop
# visualize KM estimate of survival
library(survival)
surv.obj = Surv(time = simdata$surv.data$time, 
                event = simdata$surv.data$event)
kaplan <- survfit(surv.obj ~ 1,  
                  type="kaplan-meier")
plot(kaplan)
}
\references{
Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. arXiv preprint: arXiv:2101.04426.
}
\author{
Mirko Signorelli
}
