% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_prclmm.R
\name{performance_prclmm}
\alias{performance_prclmm}
\title{Predictive performance of the PRC-LMM model}
\usage{
performance_prclmm(step2, step3, times = 1, n.cores = 1, verbose = TRUE)
}
\arguments{
\item{step2}{the output of \code{\link{summarize_lmms}} 
(step 2 of the estimation of the PRC-LMM model)}

\item{step3}{the output of \code{\link{fit_prclmm}}
(step 3 of the estimation of the PRC-LMM model)}

\item{times}{numeric vector with the time points at which
to estimate the time-dependent AUC}

\item{n.cores}{number of cores to use to parallelize the computation
of the CBOCP procedure. If \code{ncores = 1} (default), 
no parallelization is done. Pro tip: you can use 
\code{parallel::detectCores()} to check how many 
cores are available on your computer}

\item{verbose}{if \code{TRUE} (default and recommended value), information
on the ongoing computations is printed in the console}
}
\value{
A list containing the following objects:
\itemize{
\item \code{call}: the function call;
\item \code{concordance}: a data frame with the naive and
optimism-corrected estimates of the concordance (C) index;
\item \code{tdAUC}: a data frame with the naive and
optimism-corrected estimates of the time-dependent AUC
at the desired time points.
}
}
\description{
This function computes the naive and optimism-corrected
measures of performance (C index and time-dependent AUC) 
for the PRC-LMM model proposed 
in Signorelli et al. (2020, in review). The optimism
correction is computed based on a cluster bootstrap
optimism correction procedure (CBOCP)
}
\examples{
\donttest{
data(fitted_prclmm)

parallelize = FALSE
# IMPORTANT: set parallelize = TRUE to speed computations up!
if (!parallelize) n.cores = 1
if (parallelize) {
   # identify number of available cores on your machine
   n.cores = parallel::detectCores()
   if (is.na(n.cores)) n.cores = 1
}
                   
# compute the performance measures
perf = performance_prclmm(fitted_prclmm$step2, fitted_prclmm$step3, 
          times = c(0.5, 1, 1.5, 2), n.cores = n.cores)

# concordance index:
perf$concordance
# time-dependent AUC:
perf$tdAUC
}
}
\references{
Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. arXiv preprint: arXiv:2101.04426.
}
\seealso{
\code{\link{fit_lmms}} (step 1),
\code{\link{summarize_lmms}} (step 2),
\code{\link{fit_prclmm}} (step 3)
}
\author{
Mirko Signorelli
}
