% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penPHcure-package.R
\docType{package}
\name{penPHcure-package}
\alias{penPHcure-package}
\title{Variable Selection in Proportional-Hazards Cure Model with Time-Varying Covariates}
\description{
Contrary to standard survival analysis models, which rely on the assumption that the entire population will eventually experience the event of interest, mixture cure models allow to split the population in susceptible and non-susceptible (cured) individuals.

In this R package, we implement the semi-parametric proportional-hazards (PH) cure model of \insertCite{Sy_Taylor_2000;textual}{penPHcure} extended to time-varying covariates.
If we define \eqn{T} as the time-to-event, the survival function for the entire population is given by
\deqn{S(t)=(1-p)+pS(t|Y=1)}
where \eqn{p} is the incidence (i.e. probability of being susceptible) and \eqn{S(t|Y=1)} is the latency (i.e. survival function conditional on being susceptible). 

The incidence is modeled by a logistic regression model: \deqn{p=P(Y=1|\mathbf{x}_i)=\exp(\mathbf{x}_i'\textbf{b})/(1+\exp(\mathbf{x}_i'\textbf{b)}),} where \eqn{\textbf{x}_i} is a vector of time-invariant covariates (including the intercept) and \eqn{\mathbf{b}} a vector of unknown coefficients.
Whereas, the latency is modeled by a Cox’s PH model: \deqn{\lambda(t|Y=1,\textbf{z}_i(t))=\lambda_{0}(t|Y=1)e^{\textbf{z}_i'(t)\boldsymbol{\beta}},} where \eqn{\textbf{z}_i(t)} is a vector of time-varying covariates, \eqn{\lambda_{0}(t|Y=1)} is an arbitrary conditional baseline hazard function and \eqn{\boldsymbol{\beta}} is a vector of unknown coefficients.

The function \code{\link{penPHcure}} allows to:
\itemize{
 \item estimate the regression coefficients (\eqn{\textbf{b}}, \eqn{\boldsymbol{\beta}}) and the baseline hazard function \eqn{\lambda_{0}(t|Y=1)}; 
 \item compute confidence intervals for the estimated regression coefficients using the basic/percentile bootstrap method;
 \item perform variable selection with the SCAD-penalized likelihood technique proposed by \insertCite{Beretta_Heuchenne_2019;textual}{penPHcure}.
}

Moreover, the function \code{\link{penPHcure.simulate}} allows to simulate data from a PH cure model, where the event-times are generated on a continuous scale from a piecewise exponential distribution conditional on time-varying covariates, using a method similar to the one described in \insertCite{Hendry_2014;textual}{penPHcure}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{penPHcure}}, \code{\link{penPHcure.simulate}}
}
