% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_database.R
\name{freqDatabase}
\alias{freqDatabase}
\alias{getFrequencyDatabase}
\alias{setFrequencyDatabase}
\alias{readFrequencyDatabase}
\alias{writeFrequencyDatabase}
\title{Allele frequency database}
\usage{
getFrequencyDatabase(x, markers = NULL, format = c("list", "ladder"))

setFrequencyDatabase(x, database, format = c("list", "ladder"), ...)

readFrequencyDatabase(filename, format = c("list", "ladder"), ...)

writeFrequencyDatabase(
  x,
  filename,
  markers = NULL,
  format = c("list", "ladder")
)
}
\arguments{
\item{x}{A ped object, or a list of such.}

\item{markers}{A character vector (with marker names) or a numeric vector
(with marker indices).}

\item{format}{Either "list" or "ladder".}

\item{database}{Either a list or matrix/data frame with allele frequencies,
or a file path (to be passed on to \code{readFrequencyDatabase()}).}

\item{...}{Optional arguments passed on to \code{\link[=read.table]{read.table()}}.}

\item{filename}{The path to a text file containing allele frequencies either
in "list" or "allelic ladder" format.}
}
\value{
\itemize{
\item \code{getFrequencyDatabase}: either a list (if \code{format = "list"}) or a data
frame (if \code{format = "ladder"})
\item \code{readFrequencyDatabase}: a list (also if \code{format = "ladder"}) of named
numeric vectors
\item \code{setFrequencyDatabase}: a modified version of \code{x}
}
}
\description{
Functions for reading, setting and extracting allele frequency databases, in
either "list" format or "allelic ladder" format.
}
\details{
A frequency database in "list" format is a list of numeric vectors; each
vector named with the allele labels, and the list itself named with the
marker names.

Text files containing frequencies in "list" format should look as follows,
where "marker1" and "marker2" are marker names, and "a1","a2",... are allele
labels (which may be characters or numeric, but will always be converted to
characters):
\preformatted{
marker1
a1 0.2
a2 0.5
a3 0.3

marker2
a1 0.9
a2 0.1
}

A database in "allelic ladder" format is rectangular, i.e., a numeric matrix
(or data frame), with allele labels as row names and markers as column
names. \code{NA} entries correspond to unobserved alleles.
}
\examples{
loc1 = list(name = "m1", afreq = c(a = .1, b = .9))
loc2 = list(name = "m2", afreq = c("1" = .2, "10.2" = .3, "3" = .5))
x = setMarkers(singleton(1), locus = list(loc1, loc2))
db = getFrequencyDatabase(x)
db

y = setFrequencyDatabase(x, database = db)
stopifnot(identical(x, y))

# The database can also be read directly from file
tmp = tempfile()
write("m1\na 0.1\nb 0.9\n\nm2\n1 0.2\n3 0.5\n10.2 0.3", tmp)

z = setFrequencyDatabase(x, database = tmp)
stopifnot(all.equal(x, z))

}
\seealso{
\code{\link[=setLocusAttributes]{setLocusAttributes()}}, \code{\link[=setMarkers]{setMarkers()}}, \code{\link[=setAlleles]{setAlleles()}}
}
