% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_portfolio.R
\name{pq_portfolio}
\alias{pq_portfolio}
\title{calculating returns/equity of portfolio}
\usage{
pq_portfolio(dt, orders, x = "close", dtb = NULL, init_fund = NULL,
  method = "arithmetic", cols_keep = NULL, ...)
}
\arguments{
\item{dt}{a list/dataframe of price by asset.}

\item{orders}{a data frame of transaction orders, which includes symbol, date, prices, quantity and side columns.}

\item{x}{the column name of adjusted asset price, defaults to close.}

\item{dtb}{a list/dataframe of price base asset.}

\item{init_fund}{initial fund value.}

\item{method}{the method to calculate asset returns, the available values include arithmetic and log, defaults to arithmetic.}

\item{cols_keep}{the columns keep in the return data. The columns of symbol, name and date will always kept if they are exist in the input data.}

\item{...}{ignored}
}
\description{
\code{pq_portfolio} calculates the weighted returns or the equity of a portfolio assets.
}
\examples{
library(pedquant)

data(dt_banks)
datadj = md_stock_adjust(dt_banks)


# example I 
orders = data.frame(
    symbol = c("601288.SH","601328.SH","601398.SH","601939.SH","601988.SH"), 
    quantity = c(100, 200, 300, 300, 100)
)
dtRa = pq_portfolio(datadj, orders=orders) 

e1 = pq_plot(dtRa, y = 'cumreturns')
e1[[1]]


# example II 
data(dt_ssec)
orders = data.frame(
    symbol = rep(c("601288.SH","601328.SH","601398.SH","601939.SH","601988.SH"), 3), 
    date = rep(c('2009-03-02', '2010-01-04', '2014-09-01'), each = 5), 
    quantity = rep(c(100, 200, 300, 300, 100), 3) * rep(c(1, -1, 2), each = 5)
)
dtRab = pq_portfolio(datadj, orders=orders, dtb = dt_ssec, init_fund = 10000) 

e2 = pq_plot(dtRab, y = 'cumreturns', yb = 'cumreturns_000001.SH', addti = list(portfolio=list()))
e2[[1]]


# example III
orders = data.frame(symbol = "000001.SH", 
     date = c("2009-04-13", "2010-03-24", "2014-08-13", "2015-09-10"), 
     quantity = c(400, -400, 300, -300))
dtRa2 = pq_portfolio(dt_ssec, orders=orders, cols_keep = 'all')

e3 = pq_plot(dtRa2, y = 'close', addti = list(cumreturns=list(), portfolio=list()))
e3[[1]]

}
