% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lms.R
\name{pediatric_vital_sign_distributions}
\alias{pediatric_vital_sign_distributions}
\alias{p_bmi_for_age}
\alias{q_bmi_for_age}
\alias{z_bmi_for_age}
\alias{p_head_circ_for_age}
\alias{q_head_circ_for_age}
\alias{z_head_circ_for_age}
\alias{p_length_for_age_inf}
\alias{q_length_for_age_inf}
\alias{z_length_for_age_inf}
\alias{p_stature_for_age}
\alias{q_stature_for_age}
\alias{z_stature_for_age}
\alias{p_weight_for_age_inf}
\alias{q_weight_for_age_inf}
\alias{z_weight_for_age_inf}
\alias{p_weight_for_age}
\alias{q_weight_for_age}
\alias{z_weight_for_age}
\alias{p_weight_for_length_inf}
\alias{q_weight_for_length_inf}
\alias{z_weight_for_length_inf}
\alias{p_weight_for_stature}
\alias{q_weight_for_stature}
\alias{z_weight_for_stature}
\title{Pediatric Vital Sign Distributions}
\usage{
p_bmi_for_age(q, age, male)

q_bmi_for_age(p, age, male)

z_bmi_for_age(q, age, male)

p_head_circ_for_age(q, age, male)

q_head_circ_for_age(p, age, male)

z_head_circ_for_age(q, age, male)

p_length_for_age_inf(q, age, male)

q_length_for_age_inf(p, age, male)

z_length_for_age_inf(q, age, male)

p_stature_for_age(q, age, male)

q_stature_for_age(p, age, male)

z_stature_for_age(q, age, male)

p_weight_for_age_inf(q, age, male)

q_weight_for_age_inf(p, age, male)

z_weight_for_age_inf(q, age, male)

p_weight_for_age(q, age, male)

q_weight_for_age(p, age, male)

z_weight_for_age(q, age, male)

p_weight_for_length_inf(q, length, male)

q_weight_for_length_inf(p, length, male)

z_weight_for_length_inf(q, length, male)

p_weight_for_stature(q, height, male)

q_weight_for_stature(p, height, male)

z_weight_for_stature(q, height, male)
}
\arguments{
\item{q}{a vector of quantities}

\item{age}{numeric age, in months}

\item{male}{integer value, 1 = male, 0 = female}

\item{p}{a vector of probabilities}

\item{length}{length, in cm, of the patient (age under 3 years)}

\item{height}{height, in cm, of the patient (age 2 - 20 years)}
}
\value{
The \code{p_} method return values from the estimated distribution
function.  \code{q_} methods return values from the estimated quantile
function.  \code{z_} methods return standard scores, equivalent to
\code{\link[stats]{qnorm}}.
}
\description{
Based on the data provided by the CDC, provide the distribution function,
quantile function, and a z-score function for one of eight vital signs by
another vital sign, e.g., weight for age.  Values are based on an LMS
approach.
}
\examples{

#############################################################################
# BMI for Age

# A BMI of 18.2 for a 18.1 year old female is in the
p_bmi_for_age(q = 18.2, age = 18.1 * 12, male = 0)
# percentile.

# The z-score is the same as qnorm(p)
qnorm(p_bmi_for_age(q = 18.2, age = 18.1 * 12, male = 0))
z_bmi_for_age(q = 18.2, age = 18.1 * 12, male = 0)

# The 70th percentile of BMI for 15.4 year old males is
q_bmi_for_age(p = 0.70, age = 15.4 * 12, male = 1)

#############################################################################
# Stature/Lenght/Height for Age

# length_for_age_inf is for Infants are from 0 to 3 years (36 months)
# stature_for_age    is for pediatrics from 2 years (24 months) to 20 years
#                    (240 months)
# The overlap between these functions will produce slightly different values
# the kids between 24 and 36 months of age.
p_length_for_age_inf(87, age = 28, male = 0)
p_stature_for_age(87, age = 28, male = 0)
p_length_for_age_inf(q = 87, age = 28,  male = 0)

#############################################################################
# Multiple patients, the age and male, length, height arguments can also be
# vectors
p_length_for_age_inf(q = 87, age = 28,  male = 0)
p_length_for_age_inf(q = 90, age = 30,  male = 1)
p_length_for_age_inf(q = c(87,90), age = c(28, 30),  male = c(0,1))

}
\references{
\url{https://www.cdc.gov/growthcharts/percentile_data_files.htm}
}
