\name{qpearson7}
\alias{qpearson7}
\title{Evaluate the quantile function for the Pearson VII distribution with shape parameter 3/2.}
\usage{
  qpearson7(p, mu = 0, sigma = 1, lower.tail = TRUE,
    log.p = FALSE)
}
\arguments{
  \item{p}{vector of probabilities.}

  \item{mu}{vector of means.}

  \item{sigma}{vector of scales.}

  \item{log.p}{logical; if \code{TRUE}, probabilities p are
  given as log(p).}

  \item{lower.tail}{logical; if \code{TRUE} (default),
  probabilities are \eqn{P(X\le x)}, otherwise
  \eqn{P(X>x)}.}
}
\value{
  the quantile.
}
\description{
  Evaluate the quantile function for the Pearson VII
  distribution with shape parameter 3/2.
}
\details{
  If \code{mu} is not specified, it assumes the default
  value of 0. If \code{sigma} is not specified, it assumes
  the default value of 1.

  The Pearson VII distribution with location \eqn{\mu},
  scale \eqn{\sigma}, and shape 3/2 has quantile function
  \deqn{F^{-1}(x)=\mu+(\sigma/2)(2x-1)/\sqrt{x(1-x)}.}
}
\examples{
curve(qpearson7(x), 0, 1, lwd = 2, ylab = expression(F^{-1}*(x)))
curve(qnorm(x), lwd = 2, lty = 2, n = 500, add = TRUE)
}
\references{
  Hughes, J., Shastry, S., Hancock, W. O., and Fricks, J.
  (2013) Estimating velocity for processive motor proteins
  with random detachment. \emph{Journal of Agricultural,
  Biological, and Environmental Statistics}, in press.
}
\seealso{
  \code{\link{dpearson7}}, \code{\link{ppearson7}},
  \code{\link{rpearson7}}
}

