% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cow_mid_disps}
\alias{cow_mid_disps}
\title{Abbreviated CoW-MID Dispute-level Data (v. 5.0)}
\format{
A data frame with 2436 observations on the following 7 variables.
\describe{
\item{\code{dispnum}}{a numeric vector for the CoW-MID dispute number}
\item{\code{outcome}}{a numeric vector for the outcome of the MID}
\item{\code{styear}}{a numeric vector for the start year of the MID}
\item{\code{stmon}}{a numeric vector for the start month of the MID}
\item{\code{settle}}{a numeric vector for the how dispute was settled}
\item{\code{fatality}}{a numeric vector for the fatality level of the dispute}
\item{\code{mindur}}{a numeric vector for the minimum duration of the MID}
\item{\code{maxdur}}{a numeric vector for the maximum duration of the MID}
\item{\code{hiact}}{a numeric vector for the highest action of the MID}
\item{\code{hostlev}}{a numeric vector for the hostility level of the MID}
\item{\code{recip}}{a numeric vector for whether a MID was reciprocated}
}
}
\usage{
cow_mid_disps
}
\description{
This is an abbreviated version of the dispute-level CoW-MID data.
}
\details{
These data are purposely light on information; they're not intended to be used for dispute-level analyses, per se.
They're intended to augment the directed dyadic dispute-year data by adding in variables that serve as exclusion rules to whittle
the data from dyadic dispute-year to just dyad-year data.
}
\references{
Palmer, Glenn, and Roseanne W. McManus and Vito D'Orazio and Michael R. Kenwick and Mikaela Karstens
and Chase Bloch and Nick Dietrich and Kayla Kahn and Kellan Ritter and Michael J. Soules. 2021.
"The MID5 Dataset, 2011–2014: Procedures, coding rules, and description" \emph{Conflict Management and Peace Science}.
}
\keyword{datasets}
