% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_igos.R
\name{add_igos}
\alias{add_igos}
\title{Add Correlates of War international governmental organizations (IGOs) data to dyad-year or state-year data.}
\usage{
add_igos(data)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed") or a state-year data frame.}
}
\value{
\code{add_igos()} takes a dyad-year data frame or state-year data frame and adds information available from
the Correlates of War International Governmental Organizations data. If the data are dyad-year, the function returns
the original data with just one additional column for the total number of mutual IGOs for which both members of the dyad
are full members. If the data are state-year, the function returns the original data with four additional columns. These are
the number oF IGOs for which the state is a full member, the number of IGOs for which the state is an associate member, the
number of IGOs for which the state is an observer, and the number of IGOs for which the state is involved in any way (i.e. the
sum of the other three columns).
}
\description{
\code{add_igos()} allows you to add information from the Correlates of War International
Governmental Organizations data to dyad-year or state-year data, matching on Correlates of War system codes.
}
\details{
The function leans on attributes of the data that are provided by the \code{create_dyadyear()} or
\code{create_stateyear()} function. Make sure that function (or data created by that function) appear at the top
of the proverbial pipe.
}
\examples{

\donttest{

# just call library(tidyverse) at the top of the pipe
library(magrittr)

cow_ddy \%>\% add_igos()

create_stateyears() \%>\% add_igos()
}

}
\references{
Pevehouse, Jon C.W., Timothy Nordstron, Roseanne W McManus, Anne Spencer Jamison, “Tracking Organizations in the World: The Correlates of War IGO Version 3.0 datasets”, Journal of Peace Research 57(3): 492-503.

Wallace, Michael, and J. David Singer. 1970. "International Governmental Organization in the Global System, 1815-1964." International Organization 24: 239-87.
}
\author{
Steven V. Miller
}
