% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{pdSpecEst2D}
\alias{pdSpecEst2D}
\title{Intrinsic 2D wavelet-based time-varying spectral matrix estimation}
\usage{
pdSpecEst2D(P, order = c(3, 3), metric = "Riemannian", alpha = 1,
  return = "f", ...)
}
\arguments{
\item{P}{a (\eqn{d,d,m_1,m_2})-dimensional array of HPD matrices, with \eqn{m_1, m_2} both dyadic numbers.}

\item{order}{a 2-dimensional numeric vector of odd integers larger or equal to 1 corresponding to the marginal
orders of the intrinsic 2D AI refinement scheme, defaults to \code{order = c(3, 3)}. Note that the computational cost
significantly increases if \code{max(order) > 9} as the wavelet transform no longer uses a fast wavelet refinement scheme based
on pre-determined weights.}

\item{metric}{the metric that the space of HPD matrices is equipped with. The default choice is \code{"Riemannian"},
but this can also be one of: \code{"logEuclidean"}, \code{"Cholesky"}, \code{"rootEuclidean"} or
\code{"Euclidean"}. The intrinsic AI wavelet transform fundamentally relies on the chosen metric.}

\item{alpha}{an optional tuning parameter in the wavelet the thresholding procedure. If \code{policy = "universal"},
the sparsity parameter in the tree-structured wavelet thresholding procedure is set to \code{alpha} times the
universal threshold, defaults to \code{alpha = 1}.}

\item{return}{an optional argument that specifies whether the denoised spectral estimator
is returned or not.}

\item{...}{additional arguments for internal use.}
}
\value{
The function returns a list with four components:
\item{f }{a (\eqn{d,d,m_1,m_2})-dimensional array corresponding to the wavelet-denoised HPD (\eqn{d,d})-dimensional
nonstationary spectral estimate at the \eqn{m1 \times m2} different time-frequency points. If \code{!(return == 'f')},
the inverse wavelet transform of the thresholded wavelet coefficients is not computed and \code{f} is set equal to \code{NULL}.}
\item{D }{the 2D pyramid of threshold wavelet coefficients. This is a list of arrays, where each array contains the 2D grid of
(\eqn{d,d})-dimensional thresholded wavelet coefficients from the finest wavelet scale \code{j = jmax} up to the coarsest
wavelet scale \code{j = 0}.}
\item{M0 }{a numeric array containing the midpoint(s) at the coarsest scale \code{j = 0} in the 2D midpoint pyramid.}
\item{tree.weights }{a list of logical values specifying which coefficients to keep, with each list component
   corresponding to an individual wavelet scale.}
\item{D.raw }{the 2D pyramid of non-thresholded wavelet coefficients in the same format as the component \code{$D}.}
}
\description{
\code{pdSpecEst2D} calculates a \eqn{(d,d)}-dimensional HPD wavelet-denoised time-varying spectral matrix estimator
by: (i) applying an intrinsic 2D AI wavelet transform (\code{\link{WavTransf2D}}) to an initial noisy
HPD spectral estimate, (ii) (tree-structured) thresholding of the wavelet coefficients (\code{\link{pdCART}})
and (iii) applying an intrinsic inverse 2D AI wavelet transform (\code{\link{InvWavTransf2D}}).
}
\details{
The input array \code{P} corresponds to an initial noisy HPD time-varying spectral estimate of the (\eqn{d, d})-dimensional
spectral matrix at \eqn{m_1 \times m_2} different time-frequency points, with \eqn{m_1, m_2} dyadic numbers. This can be e.g.
a multitaper HPD time-varying periodogram given as output by the function \code{\link{pdPgram2D}}.\cr
\code{P} is transformed to the wavelet domain by the function \code{\link{WavTransf2D}}, which applies an intrinsic
2D AI wavelet transform based on e.g. the Riemannian metric. The noise is removed by tree-structured thresholding
of the wavelet coefficients based on the trace of the whitened coefficients as in \code{\link{pdCART}} by
minimization of a \emph{complexity penalized residual sum of squares} (CPRESS) criterion in (Donoho, 1997),
via a fast tree-pruning algorithm. As in \code{\link{pdCART}}, the sparsity parameter is set equal to \code{alpha}
times the universal threshold where the noise variance of the traces of the whitened wavelet
coefficients determined from the finest wavelet scale. \cr
If \code{return == 'f'} the thresholded wavelet coefficients are transformed back to the frequency domain by
the inverse intrinsic 2D AI wavelet transform via \code{\link{InvWavTransf2D}} giving the wavelet-denoised
HPD time-varying spectral estimate.
}
\examples{
\dontrun{
 P <- rExamples2D(c(2^7, 2^7), 3, example = "tvar")$per
 f <- pdSpecEst2D(P)
}

}
\references{
Chau, J. and von Sachs, R. (2017a). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.
}
\seealso{
\code{\link{pdPgram2D}}, \code{\link{WavTransf2D}}, \code{\link{InvWavTransf2D}}, \code{\link{pdCART}}
}
