% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial.R
\name{pdNeville}
\alias{pdNeville}
\title{Polynomial interpolation of curves (1D) or surfaces (2D) of HPD matrices}
\usage{
pdNeville(P, X, x, metric = "Riemannian")
}
\arguments{
\item{P}{for polynomial curve interpolation, a \eqn{(d, d, N)}-dimensional array corresponding to a sequence
of \eqn{(d, d)}-dimensional HPD matrices, i.e. control points, through which the interpolated polynomial
curve passes. For polynomial surface interpolation, a \eqn{(d, d, N_1, N_2)}-dimensional array corresponding
to a tensor product grid of \eqn{(d, d)}-dimensional matrices, i.e. control points, through which the interpolated
polynomial surface passes.}

\item{X}{for polynomial curve interpolation, a numeric vector of length \eqn{N} specifying the time points
the interpolated polynomial passes through the control points \code{P}. For polynomial surface interpolation, a list
with as elements two numeric vectors \code{x} and \code{y} of length \eqn{N_1} and \eqn{N_2} respectively. The numeric
vectors specify the time points on the tensor product grid \code{expand.grid(X$x, X$y)} the interpolated polynomial passes
trough the control points \code{P}.}

\item{x}{for polynomial curve interpolation, a numeric vector specifying the time grid (resolution) at which the
interpolated polynomial is estimated. For polynomial surface interpolation, a list with as elements two numeric vectors
\code{x} and \code{y} specifying the time tensor product grid (resolution) \code{expand.grid(x$x, x$y)} at which the
interpolated polynomial surface is estimated.}

\item{metric}{the metric the space of HPD gets equipped with, by default \code{metric = "Riemannian"}, but instead
this can also be set to \code{metric = "Euclidean"} to perform (standard) Euclidean polynomial interpolation of curves or
surfaces in the space of HPD matrices.}
}
\value{
For polynomial curve interpolation, a \code{(d, d, length(x))}-dimensional array containing the interpolated
polynomial of degree \eqn{N-1} at the time grid \code{x} passing through the control points \code{P} at times \code{X}.
For polynomial surface interpolation, a \code{(d, d, length(x$x), length(x$y))}-dimensional array containing the interpolated
polynomial of bi-degree \eqn{N_1 - 1, N_2 - 1} at the time grid \code{expand.grid(x$x, x$y)} passing through the control points
\code{P} at times \code{expand.grid(X$x, X$y)}.
}
\description{
\code{pdNeville()} performs intrinsic polynomial interpolation of curves or surfaces on the manifold of
HPD matrices equipped with the Riemannian metric via iterative geodesic interpolation, see e.g.
(Chau and von Sachs, 2017).
}
\details{
For polynomial curve interpolation, given \eqn{N} control points (i.e. HPD
matrices), the degree of the interpolated polynomial is \eqn{N - 1}. For polynomial surface interpolation,
given \eqn{N_1 \times N_2} control points (i.e. HPD matrices) on a tensor product grid, the interpolated
polynomial has bi-degree \eqn{(N_1 - 1, N_2 - 1)}. The function \code{pdNeville()} determines whether
polynomial curve or polynomial surface interpolation has to be performed based on the function input.
}
\examples{
### Polynomial curve interpolation
P <- rExamples(100, example = 'gaussian')$f[, , 10*(1:5)]
P.poly <- pdNeville(P, (1:5)/5, (1:50)/50)
## Examine matrix-component (1,1)
plot((1:50)/50, Re(P.poly[1, 1, ]), type = "l") ## interpolated polynomial
lines((1:5)/5, Re(P[1, 1, ]), col = 2) ## control points

### Polynomial surface interpolation
P.surf <- array(P[, , 1:4], dim = c(2,2,2,2)) ## control points
P.poly <- pdNeville(P.surf, list(x = c(0, 1), y = c(0, 1)), list(x = (0:10)/10, y = (0:10)/10))

}
\references{
Chau, J. and von Sachs, R. (2017a). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.
}
\seealso{
\code{\link{pdPolynomial}}
}
