% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pcadf}
\alias{pcadf}
\title{Function to run a PCA, plot and optionally return the data with PCA coordinates and pca object}
\usage{
pcadf(
  df = NULL,
  cols = NULL,
  color = NULL,
  facet = NULL,
  returnData = TRUE,
  ncp = NULL
)
}
\arguments{
\item{df}{Dataframe to ordinate}

\item{cols}{columns to reduce dimensions of. Can be specified with names or positions.
If this is length of 1 then it is treated as regex pattern to match
the column names that should be used.}

\item{color}{column name(s) used to color points in the pca plot.}

\item{facet}{Optional column or vector to facet plots on.}

\item{returnData}{Logical, should data be returned?}

\item{ncp}{Optional, number of principal components to return attached
to dataframe if data is returned. Defaults to all.}
}
\value{
A ggplot or list with a ggplot, a dataframe with the data and PCs, and the factominer
PCA object as elements.
}
\description{
Function to run a PCA, plot and optionally return the data with PCA coordinates and pca object
}
\details{
If data is returned then it will contain the coordinates from the
 PCA and will not contain the columns that were reduced.
}
\examples{

dists <- list(
  rlnorm = list(meanlog = log(40), sdlog = 0.5),
  rnorm = list(mean = 60, sd = 10)
)
mv <- mvSim(dists = dists, n_samples = 100, counts = 1000,
            min_bin = 1, max_bin = 180, wide = TRUE)
mv$otherGroup <- sample(c("a", "b"), size = nrow(mv), replace = TRUE)
pcadf(mv, cols = "sim_", returnData = TRUE)
pcadf(mv, cols = 2:181, color = c("group", "otherGroup"), returnData = FALSE)

}
\keyword{pca}
