% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ggplot_translator}
\alias{ggplot_translator}
\title{Translate axis label of a ggplot}
\usage{
ggplot_translator(
  gg,
  which = c("x", "y"),
  from = "en",
  to = "zh",
  keep_original_label = FALSE,
  original_sep = "\\n",
  verbose = TRUE
)
}
\arguments{
\item{gg}{a ggplot object to be translated}

\item{which}{vector contains one or more of 'x', 'y', 'label', 'fill', 'color'..., or 'facet_x', 'facet_y', 'labs' and 'all' to select which texts to be translated.}

\item{from}{source language}

\item{to}{target language}

\item{keep_original_label}{keep the source language labels}

\item{original_sep}{default, '\\n'}

\item{verbose}{verbose}
}
\value{
ggplot
}
\description{
Translate axis label of a ggplot
}
\examples{
\dontrun{
df <- data.frame(
  Subject = c("English", "Math"),
  Score = c(59, 98), Motion = c("sad", "happy")
)
ggp <- ggplot(df, mapping = aes(x = Subject, y = Score, label = Motion)) +
  geom_text() +
  geom_point() +
  labs(x = "Subject", y = "Score", title = "Final Examination")
ggplot_translator(ggp, which = "all")
}
}
