% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthocfuns.R
\name{pcoxsurvfit.pcoxtime}
\alias{pcoxsurvfit.pcoxtime}
\alias{pcoxsurvfit}
\alias{pcoxbasehaz.pcoxtime}
\alias{pcoxbasehaz}
\title{Compute survival curve and cumulative hazard from a pcoxtime model}
\usage{
\method{pcoxsurvfit}{pcoxtime}(fit, newdata, ...)

\method{pcoxbasehaz}{pcoxtime}(fit, centered = TRUE)
}
\arguments{
\item{fit}{fitted \code{\link[pcoxtime]{pcoxtime}} object}

\item{newdata}{a data frame containing the variables appearing on the right hand side of \code{\link[pcoxtime]{pcoxtime}} formula.}

\item{...}{for future implementations}

\item{centered}{if \code{TRUE} (default), return data from a predicted survival function at the mean values of the predictors, if \code{FALSE} returns prediction for all predictors equal to zero (baseline hazard).}
}
\value{
\code{pcoxsurvfit} and \code{pcoxbasehaz} return S3 objects of class \code{\link[pcoxtime]{pcoxsurvfit.pcoxtime}} and \code{\link[pcoxtime]{pcoxbasehaz.pcoxtime}}, respectively:
\item{n}{number of observations used in the fit.}
\item{events}{total number of events of interest in the fit.}
\item{time}{time points defined by the risk set.}
\item{n.risk}{the number of individuals at risk at time \code{t}.}
\item{n.event}{the number of events that occur at time \code{t}.}
\item{n.censor}{the number of subjects who exit the risk set, without an event, at time \code{t}.}
\item{surv}{a vector or a matrix of estimated survival function.}
\item{cumhaz, hazard}{a vector or a matrix of estimated cumulative hazard.}
\item{call}{the call that produced the object.}
}
\description{
Compute the predicted survivor and cumulative hazard function for a penalized Cox proportional hazard model.
}
\details{
\code{pcoxsurvfit} and \code{pcoxbasehaz} functions produce survival curves and estimated cumulative hazard, respectively, for the fitted \code{\link[pcoxtime]{pcoxtime}} model. They both return the estimated survival probability and the estimated cumulative hazard, which are both Breslow estimate.

The \code{pcoxbasehaz} is an alias for \code{pcoxsurvfit} which simply computed the predicted survival estimates (baseline).

If the \code{newdata} argument is missing, the "average" survival or cumulative hazard estimates are produced with the predictor values equal to means of the data set. See \code{\link[survival]{survfit.coxph}} for warning against this. If the \code{newdata} is specified, then the returned object will contain a matrix of both survival and cumulative hazard estimates with each column for each row in the \code{newdata}.
}
\examples{

data(heart, package="survival")
lam <- 0.1
alp <- 0.8
pfit <- pcoxtime(Surv(start, stop, event) ~ age + year + surgery + transplant
	, data = heart
	, lambda = lam
	, alpha = alp
)

# Survival estimate
psurv <- pcoxsurvfit(pfit)
print(psurv)

# Baseline survival estimate
bsurv <- pcoxbasehaz(pfit, centered = FALSE)

}
\seealso{
\code{\link[pcoxtime]{pcoxtime}}, \code{\link[pcoxtime]{plot.pcoxsurvfit}}
}
