% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{num.arcsCSend.int}
\alias{num.arcsCSend.int}
\title{Number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) - end interval case}
\usage{
num.arcsCSend.int(Xp, int, t)
}
\arguments{
\item{Xp}{A \code{vector} of 1D points which constitute the vertices of the digraph.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}
}
\value{
Number of arcs for the CS-PCD with vertices being 1D data set, \code{Xp},
expansion parameter, \code{t}, for the end intervals.
}
\description{
Returns the number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) whose
vertices are a 1D numerical data set, \code{Xp}, outside the interval \code{int}\eqn{=(a,b)}.

CS proximity region is constructed only with expansion parameter \eqn{t>0} for points outside the interval \eqn{(a,b)}.

End vertex regions are based on the end points of the interval,
i.e., the corresponding end vertex region is an interval as \eqn{(-\infty,a)} or \eqn{(b,\infty)} for the interval \eqn{(a,b)}.
For the number of arcs, loops are not allowed, so arcs are only possible for points outside
the interval, \code{int}, for this function.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
a<-0; b<-10; int<-c(a,b)

n<-5
XpL<-runif(n,a-5,a)
XpR<-runif(n,b,b+5)
Xp<-c(XpL,XpR)

num.arcsCSend.int(Xp,int,t=2)

num.arcsCSend.int(Xp,int,t=1.2)

num.arcsCSend.int(Xp,int,t=4)

num.arcsCSend.int(Xp,int,t=2+5)
#num.arcsCSend.int(Xp,int,t=c(-5,15))

n<-10  #try also n<-20
Xp2<-runif(n,a-5,b+5)
num.arcsCSend.int(Xp2,int,t=2)

t<-.5
num.arcsCSend.int(Xp,int,t)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.arcsCSmid.int}}, \code{\link{num.arcsPEmid.int}}, and \code{\link{num.arcsPEend.int}}
}
\author{
Elvan Ceyhan
}
