% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{IndNPETeSet}
\alias{IndNPETeSet}
\title{The indicator for the presence of an arc from a point in set \code{S} to the point \code{p} for Proportional Edge
Proximity Catch Digraphs (PE-PCDs) - standard equilateral triangle case}
\usage{
IndNPETeSet(S, p, r, M = c(1, 1, 1))
}
\arguments{
\item{S}{A set of 2D points. Presence of an arc from a point in \code{S} to point \code{p} is checked
by the function.}

\item{p}{A 2D point. Presence of an arc from a point in \code{S} to point \code{p} is checked
by the function.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region in the
standard equilateral triangle \eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))}; must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)}
i.e., the center of mass of \eqn{T_e}.}
}
\value{
I(\code{p} is in U_{x in \code{S}} N_{PE}(x,r)), that is, returns 1 if \code{p} is in \code{S} or inside \eqn{N_{PE}(x,r)} for at least
one \eqn{x} in \code{S}, returns 0 otherwise. PE proximity region is constructed with respect to the standard
equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with \code{M}-vertex regions
}
\description{
Returns \eqn{I(}\code{p} in \eqn{N_{PE}(x,r)} for some \eqn{x} in \code{S}\eqn{)}, that is, returns 1 if \code{p} is in \eqn{\cup_{x in S}N_{PE}(x,r)},
returns 0 otherwise.

PE proximity region is constructed with respect to the standard equilateral triangle
\eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with the expansion parameter \eqn{r \ge 1} and vertex regions are based
on center \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e} (which is equivalent to the circumcenter
for \eqn{T_e}).

Vertices of \eqn{T_e} are also labeled as 1, 2, and 3, respectively.
If \code{p} is not in \code{S} and either \code{p} or all points in \code{S} are outside \eqn{T_e}, it returns 0,
but if \code{p} is in \code{S}, then it always returns 1 regardless of its location (i.e., loops are allowed).
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

r<-1.5

S<-rbind(Xp[1,],Xp[2,])  #try also S<-c(.5,.5)
IndNPETeSet(S,Xp[3,],r,M)
IndNPETeSet(S,Xp[3,],r=1,M)

S<-rbind(Xp[1,],Xp[2,],Xp[3,],Xp[5,])
IndNPETeSet(S,Xp[3,],r,M)

IndNPETeSet(S,Xp[6,],r,M)
IndNPETeSet(S,Xp[6,],r=1.25,M)

P<-c(.4,.2)
S<-Xp[c(1,3,4),]
IndNPETeSet(Xp,P,r,M)
}

}
\seealso{
\code{\link{IndNPEtriSet}}, \code{\link{IndNPETe}}, \code{\link{IndNPEtri}}, and \code{\link{IndNCSTeSet}}
}
\author{
Elvan Ceyhan
}
