% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{NumArcsPETe}
\alias{NumArcsPETe}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - standard equilateral triangle case}
\usage{
NumArcsPETe(Xp, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the PE-PCD.}

\item{r}{A positive real number which serves as the expansion parameter for PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
A \code{list} with the elements
\item{num.arcs}{Number of arcs of the PE-PCD}
\item{num.in.tri}{Number of \code{Xp} points in the standard equilateral triangle, \eqn{T_e}}
\item{ind.in.tri}{The vector of indices of the \code{Xp} points that reside in \eqn{T_e}}
}
\description{
Returns the number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) whose vertices are the
given 2D numerical data set, \code{Xp}. It also provides number of vertices (i.e., number of data points inside the triangle)
and indices of the data points that reside in the triangle.

PE proximity region \eqn{N_{PE}(x,r)} is defined with respect to the standard
equilateral triangle \eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with expansion parameter \eqn{r \ge 1}
and vertex regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.
For the number of arcs, loops are not allowed so
arcs are only possible for points inside \eqn{T_e} for this function.

See also (\insertCite{ceyhan:arc-density-PE;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-c(.6,.2)  #try also M<-c(1,1,1)

NumArcsPETe(Xp,r=1.25,M)
NumArcsPETe(Xp,r=1.5,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsPEtri}}, \code{\link{NumArcsPE}}, and \code{\link{NumArcsCSTe}}
}
\author{
Elvan Ceyhan
}
