% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NCStri}
\alias{NCStri}
\title{The vertices of the Central Similarity (CS) Proximity Region in a general triangle}
\usage{
NCStri(pt, tau, tri, M, re = NULL)
}
\arguments{
\item{pt}{A 2D point whose CS proximity region is to be computed.}

\item{tau}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}.}

\item{re}{Index of the \code{M}-edge region containing the point \code{pt},
either \code{1,2,3} or \code{NULL} (default is \code{NULL}).}
}
\value{
Vertices of the triangular region which constitutes the CS proximity region with expansion parameter
\eqn{\tau>0} and center \code{M} for a point \code{pt}
}
\description{
Returns the vertices of the CS proximity region (which is itself a triangle) for a point in the
triangle \code{tri}\eqn{=T(A,B,C)=}\code{(rv=1,rv=2,rv=3)}.

CS proximity region is defined with respect to the triangle \code{tri}
with expansion parameter \eqn{t>0} and edge regions based on center \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri}.

Edge regions are labeled as \code{1,2,3} rowwise for the corresponding vertices
of the triangle \code{tri}. \code{re} is the index of the edge region \code{pt} resides, with default=\code{NULL}.
If \code{pt} is outside of \code{tri}, it returns \code{NULL} for the proximity region.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
tau<-1.5

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

n<-10
set.seed(1)
dat<-runif.tri(n,Tr)$g

NCStri(dat[7,],tau,Tr,M)

P1<-as.numeric(runif.tri(1,Tr)$g)  #try also P1<-c(.4,.2)
NCStri(P1,tau,Tr,M)

P2<-c(1.8,.5)
NCStri(P2,tau,Tr,M)

P3<-c(1.7,.6)
NCStri(P3,tau,Tr,M)

#or try
re<-redges.tri.cent(P2,Tr,M)$re
NCStri(P2,tau,Tr,M,re)

dat.fr<-data.frame(a=Tr)
NCStri(P2,tau,dat.fr,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NPEtri}}, \code{\link{NAStri}}, and  \code{\link{IndNCStri}}
}
\author{
Elvan Ceyhan
}
