% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndNCSmid1D}
\alias{IndNCSmid1D}
\title{The indicator for the presence of an arc from a point to another for Central Similarity
Proximity Catch Digraphs (CS-PCDs) - middle interval case}
\usage{
IndNCSmid1D(x1, x2, t, c, int, rv = NULL)
}
\arguments{
\item{x1, x2}{1D points; \eqn{x_1} is the point for which the proximity region, \eqn{N_{CS}(x_1,t,c)} is
constructed and \eqn{x_2} is the point which the function is checking whether its inside
\eqn{N_{CS}(x_1,t,c)} or not.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{rv}{Index of the end interval containing the point, either \code{1,2} or \code{NULL} (default is \code{NULL}).}
}
\value{
\eqn{I(x_2} in \eqn{N_{CS}(x_1,t,c))} for points \eqn{x_1} and \eqn{x_2} that is, returns 1 if \eqn{x_2} is in \eqn{N_{CS}(x_1,t,c)},
returns 0 otherwise
}
\description{
Returns \eqn{I(x_2} in \eqn{N_{CS}(x_1,t,c))} for points \eqn{x_1} and \eqn{x_2}, that is, returns 1 if \eqn{x_2} is in \eqn{N_{CS}(x_1,t,c)}, returns 0
otherwise, where \eqn{N_{CS}(x,t,c)} is the CS proximity region for point \eqn{x} and is constructed with expansion
parameter \eqn{t>0} and centrality parameter \eqn{c \in (0,1)} for the interval \eqn{(a,b)}.

CS proximity regions are defined with respect to the middle interval \code{int} and vertex regions are based
on the center associated with the centrality parameter \eqn{c \in (0,1)}. For the interval, \code{int}\eqn{=(a,b)}, the
parameterized center is \eqn{M_c=a+c(b-a)}. \code{rv} is the index of the vertex region \eqn{x_1} resides, with default=\code{NULL}.

If \eqn{x_1} and \eqn{x_2} are distinct and either of them are outside interval \code{int}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations
(i.e., loops are allowed in the digraph).

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.5
t<-2
a<-0; b<-10; int<-c(a,b)

IndNCSmid1D(7,5,t,c,int)
IndNCSmid1D(7,7,t,c,int)
IndNCSmid1D(7,5,t,c=.4,int)

IndNCSmid1D(1,3,t,c,int)

IndNCSmid1D(9,11,t,c,int)

IndNCSmid1D(19,1,t,c,int)
IndNCSmid1D(19,19,t,c,int)

IndNCSmid1D(3,5,t,c,int)

#or try
Rv<-rv.mid.int(3,c,int)$rv
IndNCSmid1D(3,5,t,c,int,rv=Rv)

IndNCSmid1D(7,5,t,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNCSend1D}}, \code{\link{IndNPEmid1D}}, and \code{\link{IndNPEend1D}}
}
\author{
Elvan Ceyhan
}
