% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{funsCSEdgeRegs}
\alias{funsCSEdgeRegs}
\alias{IndCSTeRAB}
\alias{IndCSTeRBC}
\alias{IndCSTeRAC}
\title{Each function is for the presence of an arc from a point in one of the edge regions
to another for Central Similarity Proximity Catch Digraphs (CS-PCDs) - standard equilateral triangle case}
\usage{
IndCSTeRAB(pt1, pt2, t, M)

IndCSTeRBC(pt1, pt2, t, M)

IndCSTeRAC(pt1, pt2, t, M)
}
\arguments{
\item{pt1}{A 2D point whose CS proximity region is constructed.}

\item{pt2}{A 2D point. The function determines whether \code{pt2} is inside the CS proximity region of
\code{pt1} or not.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}.}
}
\value{
Each function returns \eqn{I(}\code{pt2} is in \eqn{N_{CS}(pt1,t))} for \code{pt1}, that is, returns 1 if \code{pt2} is in \eqn{N_{CS}(pt1,t)},
returns 0 otherwise
}
\description{
Three indicator functions: \code{IndCSTeRAB}, \code{IndCSTeRBC} and \code{IndCSTeRAC}.

The function \code{IndCSTeRAB} returns I(\code{pt2} is in \eqn{N_{CS}(pt1,t)} for \code{pt1} in \eqn{RAB} (edge region for edge \eqn{AB},
i.e., edge 3) in the standard equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))};

\code{IndCSTeRBC} returns I(\code{pt2} is in \eqn{N_{CS}(pt1,t)} for \code{pt1} in \eqn{RBC} (edge region for edge \eqn{BC}, i.e., edge 1) in \eqn{T_e};
and

\code{IndCSTeRAC} returns I(\code{pt2} is in \eqn{N_{CS}(pt1,t)} for \code{pt1} in \eqn{RAC} (edge region for edge \eqn{AC}, i.e., edge 2) in \eqn{T_e}.
That is, each function returns 1 if \code{pt2} is in \eqn{N_{CS}(pt1,t)}, returns 0 otherwise.

CS proximity region is defined with respect to \eqn{T_e} whose vertices are also labeled as \eqn{T_e=T(v=1,v=2,v=3)}
with expansion parameter \eqn{t>0} and edge regions are based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e}

If \code{pt1} and \code{pt2} are distinct and \code{pt1} is outside the corresponding edge region and \code{pt2} is outside \eqn{T_e}, it returns 0,
but if they are identical, then it returns 1 regardless of their location (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
#Examples for IndCSTeRAB
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T3<-rbind(A,B,CM);

set.seed(1)
dat3<-runif.tri(10,T3)$g
dat<-runifTe(10)$gen.points

M<-as.numeric(runifTe(1)$g)  #try also M<-c(.6,.2)

t<-1

IndCSTeRAB(dat3[1,],dat[2,],t,M)
IndCSTeRAB(dat3[1,],dat3[1,],t,M)
IndCSTeRAB(dat[1,],dat[1,],t,M)

IndCSTeRAB(dat3[1,],dat[2,],t=20,M)
IndCSTeRAB(dat3[1,],dat3[3,],t,M)
IndCSTeRAB(c(.2,.5),dat[2,],t,M)

IndCSTeRAB(dat[1,],dat[2,],t,M)

#Examples for IndCSTeRBC
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T1<-rbind(B,C,CM);

set.seed(1)
dat1<-runif.tri(10,T1)$g
dat<-runifTe(10)$gen.points

M<-as.numeric(runifTe(1)$g)  #try also M<-c(.6,.2)

t<-1

IndCSTeRBC(dat1[1,],dat[2,],t,M)
IndCSTeRBC(dat1[1,],dat1[1,],t,M)

IndCSTeRBC(dat[2,],dat[2,],t,M)
IndCSTeRBC(dat1[1,],dat[2,],t=20,M)
IndCSTeRBC(dat1[1,],dat1[3,],t,M)
IndCSTeRBC(c(.2,.5),dat[2,],t,M)

IndCSTeRBC(c(.2,.5),c(.2,.5),t,M)

IndCSTeRBC(dat[1,],dat[2,],t,M)

#Examples for IndCSTeRAC
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T2<-rbind(A,C,CM);

set.seed(1)
dat2<-runif.tri(10,T2)$g
dat<-runifTe(10)$gen.points

M<-as.numeric(runifTe(1)$g)  #try also M<-c(.6,.2)

t<-1

IndCSTeRAC(dat2[1,],dat[2,],t,M)
IndCSTeRAC(dat2[1,],dat2[1,],t,M)
IndCSTeRAC(dat[1,],dat[1,],t,M)

IndCSTeRAC(dat2[1,],dat2[3,],t,M)
IndCSTeRAC(dat2[1,],dat2[3,],t=20,M)
IndCSTeRAC(c(.2,.5),dat[2,],t,M)

IndCSTeRAC(c(.2,.5),c(.2,.5),t,M)

IndCSTeRAC(dat[1,],dat[2,],t,M)

}
\seealso{
\code{\link{IndCSTeRABt1}}, \code{\link{IndCSTeRBCt1}} and \code{\link{IndCSTeRACt1}}
}
\author{
Elvan Ceyhan
}
