% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsPETe}
\alias{NumArcsPETe}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - standard
equilateral triangle case}
\usage{
NumArcsPETe(dat, r, M = c(1, 1, 1))
}
\arguments{
\item{dat}{A set of 2D points which constitute the vertices of the PE-PCD.}

\item{r}{A positive real number which serves as the expansion parameter for PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
Number of arcs for the PE-PCD with vertices being 2D data set, \code{dat}, in \eqn{T_e}
with expansion parameter, \eqn{r \ge 1}, and \code{M}-vertex regions. PE proximity regions are defined only
for \code{dat} points inside \eqn{T_e}, i.e., arcs are possible for such points only.
}
\description{
Returns the number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) whose vertices are the
given 2D numerical data set, \code{dat}.

PE proximity region \eqn{N_{PE}(x,r)} is defined with respect to the standard
equilateral triangle \eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with expansion parameter \eqn{r \ge 1}
and vertex regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.
For the number of arcs, loops are not allowed so
arcs are only possible for points inside \eqn{T_e} for this function.

See also (\insertCite{ceyhan:arc-density-PE;textual}{pcds}).
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
n<-10  #try also n<-20

set.seed(1)
dat<-runifTe(n)$gen.points

M<-c(.6,.2)  #try also M<-c(1,1,1)

NumArcsPETe(dat,r=1.25,M)
NumArcsPETe(dat,r=1.5,M)
NumArcsPETe(dat,r=2,M)

NumArcsPETe(rbind(dat,c(0,1)),r=2,M)
NumArcsPETe(c(.2,.3),r=2,M)

NumArcsPETe(dat,r=1.5,M);

dat.fr<-data.frame(a=dat)
NumArcsPETe(dat.fr,r=1.5,M);

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsPEtri}}, \code{\link{NumArcsPEMT}}, and \code{\link{NumArcsCSTe}}
}
\author{
Elvan Ceyhan
}
